/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.attributes;

import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.trait.EntityProvider;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.Constants;
import org.cotrix.domain.values.ValueType;

public interface Attribute
extends Identified,
Named {
    public Definition definition();

    public QName type();

    public boolean is(QName var1);

    public String value();

    public String language();

    public String description();

    public static final class Private
    extends Identified.Abstract<Private, State>
    implements Attribute {
        private static final String validationErrorMsg = "%s cannot be assigned to attribute %s, as violates  constraint %s";

        public Private(State state) {
            super(state);
        }

        @Override
        public Definition definition() {
            return (Definition)((State)this.state()).definition().entity();
        }

        @Override
        public QName name() {
            return ((State)this.state()).name();
        }

        @Override
        public QName type() {
            return ((State)this.state()).type();
        }

        @Override
        public boolean is(QName name) {
            return ((State)this.state()).is(name);
        }

        @Override
        public String value() {
            return ((State)this.state()).value();
        }

        @Override
        public String language() {
            return ((State)this.state()).language();
        }

        @Override
        public String description() {
            return ((State)this.state()).description();
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            if (changeset.value() != null) {
                ((State)this.state()).value(changeset.value() == "__ignore__" ? null : this.validateAndUpdateValue(changeset.value()));
            }
            if (changeset.name() == Constants.NULL_QNAME) {
                throw new IllegalArgumentException("attribute name " + this.name() + " cannot be erased");
            }
            if (changeset.name() != null) {
                ((State)this.state()).name(changeset.name());
            }
            if (changeset.type() == Constants.NULL_QNAME) {
                throw new IllegalArgumentException("attribute type " + this.type() + " cannot be erased");
            }
            if (changeset.type() != null) {
                ((State)this.state()).type(changeset.type());
            }
            if (changeset.language() != null) {
                ((State)this.state()).language(changeset.language() == "__ignore__" ? null : changeset.language());
            }
            if (changeset.description() != null) {
                ((State)this.state()).description(changeset.description() == "__ignore__" ? null : changeset.description());
            }
        }

        public String toString() {
            return "attr [id=" + this.id() + ", value=" + this.value() + ", def=" + this.definition() + (this.status() == null ? "" : " (" + (Object)((Object)this.status()) + ") ") + "]";
        }

        private String validateAndUpdateValue(String value) {
            ValueType type = this.definition().valueType();
            if (!type.isValid(value)) {
                throw new IllegalArgumentException(String.format(validationErrorMsg, value, this.name(), type.constraints().asSingleConstraint()));
            }
            return value;
        }
    }

    public static interface State
    extends Identified.State,
    Named.State,
    EntityProvider<Private> {
        public Definition.State definition();

        public void definition(Definition.State var1);

        public QName type();

        public String value();

        public String language();

        public String description();

        public void type(QName var1);

        public void value(String var1);

        public void language(String var1);

        public void description(String var1);

        public boolean is(QName var1);
    }
}

