/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.validation;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.cotrix.domain.validation.Constraint;

public final class Constraints
implements Iterable<Constraint> {
    private static String conditionTemplate = "(%s)";
    private final List<Constraint> constraints;

    public Constraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.constraints.iterator();
    }

    public Constraint asSingleConstraint() {
        return new Constraint("composition", this.compose(), Collections.emptyMap());
    }

    private String compose() {
        if (this.constraints.isEmpty()) {
            return "true";
        }
        String first = String.format(conditionTemplate, this.constraints.get(0).expression());
        StringBuilder builder = new StringBuilder(first);
        for (int i = 1; i < this.constraints.size(); ++i) {
            builder.append(" && ").append(String.format(conditionTemplate, this.constraints.get(i).expression()));
        }
        return builder.toString();
    }
}

