/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.links;

import java.util.ArrayList;
import java.util.List;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.links.LinkValueType;
import org.cotrix.domain.utils.AttributeTemplate;

public class AttributeLink
implements LinkValueType {
    private final AttributeTemplate template;

    public AttributeLink(AttributeTemplate template) {
        CommonUtils.notNull((String)"template", (Object)template);
        this.template = template;
    }

    public AttributeTemplate template() {
        return this.template;
    }

    @Override
    public List<Object> valueIn(String linkId, Code.Bean code, List<String> ids) {
        ArrayList<Object> matches = new ArrayList<Object>();
        for (Attribute.Bean a : code.attributes()) {
            if (!this.template.matches(a)) continue;
            matches.add(a.value());
        }
        return matches;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeLink other = (AttributeLink)obj;
        return !(this.template == null ? other.template != null : !this.template.equals(other.template));
    }
}

