/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.user;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cotrix.action.Action;
import org.cotrix.action.ResourceType;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;

public class FingerPrint {
    private Map<ResourceType, Map<String, Rights>> fp = new HashMap<ResourceType, Map<String, Rights>>();

    public FingerPrint(User user) {
        for (Action p : user.permissions()) {
            this.rightsOver(p.resource(), p.type()).permissions.add(p);
        }
        for (Role r : user.roles()) {
            this.rightsOver(r.resource(), r.type()).roles.add(r.name());
        }
    }

    public Collection<ResourceType> types() {
        return this.fp.keySet();
    }

    public Collection<String> resources(ResourceType type) {
        HashSet<String> resources = this.fp.containsKey(type) ? this.fp.get(type).keySet() : new HashSet<String>();
        return resources;
    }

    public Collection<String> resourcesFor(String role, ResourceType type) {
        HashSet<String> resources = new HashSet<String>();
        for (String resource : this.resources(type)) {
            if (!this.rightsOver(resource, type).roles.contains(role)) continue;
            resources.add(resource);
        }
        return resources;
    }

    public Collection<String> specificRolesOver(String resource, ResourceType type) {
        Rights rights = this.target(resource, type);
        HashSet<String> roles = rights == null ? new HashSet() : rights.roles;
        return roles;
    }

    public Collection<String> allRolesOver(String resource, ResourceType type) {
        Collection<String> roles = this.specificRolesOver(resource, type);
        if (!resource.equals("*")) {
            roles.addAll(this.specificRolesOver("*", type));
        }
        return roles;
    }

    public Collection<Action> permissionsOver(String resource, ResourceType type) {
        Set<Action> permissions;
        Rights rights = this.target(resource, type);
        Collection<Object> collection = permissions = rights == null ? Collections.emptySet() : rights.permissions;
        if (!resource.equals("*")) {
            permissions.addAll(this.permissionsOver("*", type));
        }
        return permissions;
    }

    public Collection<Action> specificPermissionsOver(String resource, ResourceType type) {
        Set<Action> permissions;
        Rights rights = this.target(resource, type);
        Collection<Object> collection = permissions = rights == null ? Collections.emptySet() : rights.permissions;
        if (!resource.equals("*")) {
            permissions.addAll(this.permissionsOver("*", type));
        }
        return permissions;
    }

    private Rights target(String resource, ResourceType type) {
        Map<String, Rights> roleMap = this.fp.get(type);
        return roleMap != null ? roleMap.get(resource) : null;
    }

    private Rights rightsOver(String resource, ResourceType type) {
        Rights randp;
        Map<String, Rights> resourceMap = this.fp.get(type);
        if (resourceMap == null) {
            resourceMap = new HashMap<String, Rights>();
            this.fp.put(type, resourceMap);
        }
        if ((randp = resourceMap.get(resource)) == null) {
            randp = new Rights();
            resourceMap.put(resource, randp);
        }
        return randp;
    }

    public String toString() {
        return this.fp.toString();
    }

    class Rights {
        private Collection<String> roles = new HashSet<String>();
        private Collection<Action> permissions = new HashSet<Action>();

        Rights() {
        }

        public String toString() {
            return "[roles=" + (this.roles != null ? this.roles.toString() : null) + ", permissions=" + (this.permissions != null ? this.permissions.toString() : null) + "]";
        }
    }
}

