/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.values;

import org.cotrix.common.script.ScriptEngineProvider;
import org.cotrix.domain.values.ValueFunction;

public class ValueFunctions {
    public static final ValueFunction identity = new ValueFunction.Abstract("identity"){

        @Override
        public String apply(String value) {
            return value;
        }
    };
    public static final ValueFunction uppercase = new ValueFunction.Abstract("uppercase"){

        @Override
        public String apply(String value) {
            return value.toUpperCase();
        }
    };
    public static final ValueFunction lowercase = new ValueFunction.Abstract("lowercase"){

        @Override
        public String apply(String value) {
            return value.toLowerCase();
        }
    };

    public static PrefixFunction prefix(String prefix) {
        return new PrefixFunction(prefix);
    }

    public static ValueFunction suffix(String suffix) {
        return new SuffixFunction(suffix);
    }

    public static CustomFunction custom(String expression) {
        return new CustomFunction(expression);
    }

    public static class CustomFunction
    extends ValueFunction.Abstract {
        private final String expression;

        public CustomFunction(String expression) {
            super("generic");
            this.expression = expression;
        }

        public String expression() {
            return this.expression;
        }

        @Override
        public String apply(String value) {
            try {
                return ScriptEngineProvider.engine().eval(this.expression).with(value);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot compute link value through generic function (see cause)", e);
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomFunction other = (CustomFunction)obj;
            return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
        }
    }

    public static class SuffixFunction
    extends ValueFunction.Abstract {
        private final String suffix;

        public SuffixFunction(String suffix) {
            super("suffix");
            this.suffix = suffix;
        }

        public String suffix() {
            return this.suffix;
        }

        @Override
        public String apply(String value) {
            return value + this.suffix;
        }
    }

    public static class PrefixFunction
    extends ValueFunction.Abstract {
        private final String prefix;

        public PrefixFunction(String prefix) {
            super("prefix");
            this.prefix = prefix;
        }

        public String prefix() {
            return this.prefix;
        }

        @Override
        public String apply(String value) {
            return this.prefix + value;
        }
    }
}

