/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.cotrix.action.Action;
import org.cotrix.action.Actions;
import org.cotrix.common.Utils;
import org.cotrix.common.cdi.BeanSession;
import org.cotrix.common.cdi.Current;
import org.cotrix.domain.user.User;
import org.cotrix.engine.Engine;
import org.cotrix.engine.TaskOutcome;
import org.cotrix.engine.impl.EngineDelegate;
import org.cotrix.engine.impl.Task;

@ApplicationScoped
public class DefaultEngine
implements Engine {
    @Inject
    @Current
    private BeanSession session;
    @Inject
    private List<EngineDelegate> delegates;

    @Override
    public Engine.TaskClause perform(final Action a) {
        Utils.notNull((String)"action", (Object)a);
        return new Engine.TaskClause(){

            @Override
            public <T> TaskOutcome<T> with(Callable<T> task) {
                return DefaultEngine.this.perform(a, Task.taskFor(task));
            }
        };
    }

    private <T> TaskOutcome<T> perform(Action action, Task<T> task) {
        User user = (User)this.session.get(User.class);
        Collection permissions = Actions.filterForAction((Action)action, (Collection)user.permissions());
        if (!action.included(permissions)) {
            throw new IllegalAccessError(user + " cannot perform " + action + ", as her permissions allow only " + permissions);
        }
        for (EngineDelegate delegate : this.delegates) {
            if (delegate.type() != action.type()) continue;
            return delegate.perform(action, task, user.id(), permissions);
        }
        return new TaskOutcome<T>(permissions, task.execute(action));
    }

    @Produces
    static List<EngineDelegate> produces(Instance<EngineDelegate> ds) {
        ArrayList<EngineDelegate> delegates = new ArrayList<EngineDelegate>();
        for (EngineDelegate delegate : ds) {
            delegates.add(delegate);
        }
        return delegates;
    }
}

