/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.engine.impl;

import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.action.Action;
import org.cotrix.action.ResourceType;
import org.cotrix.engine.TaskOutcome;
import org.cotrix.engine.impl.EngineDelegate;
import org.cotrix.engine.impl.Task;
import org.cotrix.lifecycle.Lifecycle;
import org.cotrix.lifecycle.LifecycleService;

@Singleton
public class CodelistActionDelegate
implements EngineDelegate {
    @Inject
    private LifecycleService lcService;

    @Override
    public ResourceType type() {
        return ResourceType.codelists;
    }

    @Override
    public <T> TaskOutcome<T> perform(Action action, Task<T> task, String user, Collection<Action> permissions) {
        String resource = action.resource();
        Lifecycle lifecycle = this.lcService.lifecycleOf(resource);
        Collection allowed = lifecycle.allowed();
        if (!action.included(allowed)) {
            throw new IllegalStateException(user + " cannot perform " + action + ", as codelist " + lifecycle.resourceId() + " is in state " + lifecycle.state() + " and its lifecycle allows only " + lifecycle.allowed());
        }
        T outcome = task.execute(action);
        lifecycle.notify(action);
        this.lcService.update(lifecycle);
        Iterator<Action> it = permissions.iterator();
        while (it.hasNext()) {
            Action permission = it.next();
            if (permission.included(allowed)) continue;
            it.remove();
        }
        return new TaskOutcome<T>(permissions, outcome);
    }
}

