/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.gcube.extension;

import java.util.Collection;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.cotrix.action.Action;
import org.cotrix.action.UserAction;
import org.cotrix.common.Utils;
import org.cotrix.common.cdi.BeanSession;
import org.cotrix.common.cdi.Current;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.gcube.extension.PortalProxy;
import org.cotrix.gcube.extension.PortalProxyProvider;
import org.cotrix.gcube.extension.RoleMapper;
import org.cotrix.gcube.stubs.PortalUser;
import org.cotrix.gcube.stubs.SessionToken;
import org.cotrix.repository.UserQueries;
import org.cotrix.repository.UserRepository;
import org.cotrix.security.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
@Priority(value=1000)
public class GCubeRealm
implements Realm {
    private Logger logger = LoggerFactory.getLogger(GCubeRealm.class);
    @Inject
    private PortalProxyProvider safePortalUrlProvider;
    @Inject
    private PortalProxyProvider portalProxyProvider;
    @Inject
    private UserRepository userRepository;
    @Inject
    private RoleMapper roleMapper;
    @Inject
    @Current
    private BeanSession session;

    public boolean supports(Object token) {
        return token instanceof SessionToken;
    }

    public String login(Object token) {
        SessionToken stoken = (SessionToken)Utils.reveal((Object)token, SessionToken.class);
        PortalProxy portalProxy = this.portalProxyProvider.getPortalProxy(stoken);
        this.session.add(PortalProxy.class, (Object)portalProxy);
        PortalUser external = portalProxy.getPortalUser();
        User internal = (User)this.userRepository.get(UserQueries.userByName((String)external.userName()));
        if (internal == null) {
            this.intern(external);
        } else {
            this.update(external, internal);
        }
        return external.userName();
    }

    protected void intern(PortalUser external) {
        this.logger.info("interning external gCube user: {}", (Object)external);
        Collection<Role> roles = this.roleMapper.map(external.roles());
        User user = Users.user().name(external.userName()).email(external.email()).fullName(external.fullName()).is(roles).build();
        this.userRepository.add((Object)user);
        User changeset = Users.modifyUser((User)user).can(new Action[]{UserAction.VIEW.on(user.id())}).build();
        this.userRepository.update((Object)changeset);
    }

    protected void update(PortalUser external, User internal) {
        this.logger.trace("updating internal user from external gCube user: {}", (Object)external);
        Collection<Role> roles = this.roleMapper.map(external.roles());
        User modified = Users.modifyUser((User)internal).email(external.email()).fullName(external.fullName()).isNoLonger(internal.directRoles()).is(roles).build();
        this.userRepository.update((Object)modified);
    }

    public void add(String name, String pwd) {
        throw new UnsupportedOperationException("sign up active only through iMarine portal");
    }
}

