/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.gcube.extension;

import javax.enterprise.event.Observes;
import org.cotrix.action.events.CodelistActionEvents;
import org.cotrix.gcube.extension.PortalProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubePublisher {
    protected Logger logger = LoggerFactory.getLogger(GCubePublisher.class);

    public void onImportEvent(@Observes CodelistActionEvents.Import importEvent) {
        this.logger.trace("onImportEvent event: {}", (Object)importEvent);
        PortalProxy portalProxy = (PortalProxy)importEvent.session.get(PortalProxy.class);
        portalProxy.publish(importEvent.name + " version " + importEvent.version + " now available.");
    }

    public void onPublishEvent(@Observes CodelistActionEvents.Publish publishEvent) {
        this.logger.trace("onPublishEvent event: {}", (Object)publishEvent);
        PortalProxy portalProxy = (PortalProxy)publishEvent.session.get(PortalProxy.class);
        portalProxy.publish(publishEvent.name + " version " + publishEvent.version + " has just been published to " + publishEvent.repository + ".");
    }

    public void onVersionEvent(@Observes CodelistActionEvents.Version versionEvent) {
        this.logger.trace("onVersionEvent event: {}", (Object)versionEvent);
        PortalProxy portalProxy = (PortalProxy)versionEvent.session.get(PortalProxy.class);
        portalProxy.publish("version " + versionEvent.version + " of " + versionEvent.name + " now available.");
    }
}

