/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.gcube.extension;

import java.net.URL;
import org.cotrix.gcube.extension.DefaultHttpClient;
import org.cotrix.gcube.extension.HttpClient;
import org.cotrix.gcube.extension.PortalProxy;
import org.cotrix.gcube.stubs.News;
import org.cotrix.gcube.stubs.PortalUser;
import org.cotrix.gcube.stubs.PortalUserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPortalProxy
implements PortalProxy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPortalProxy.class);
    private static final String USER_SERVICE_PATH = "/cotrix-gcube-portlet/user";
    private static final String NEWS_SERVICE_PATH = "/cotrix-gcube-portlet/news";
    private static final String SUCCESSFULL_RESPONSE = "OK";
    protected HttpClient httpClient = new DefaultHttpClient();
    protected String portalUrl;
    protected String sessionId;
    private String cookie;

    public DefaultPortalProxy(String portalUrl, String sessionId) {
        this.portalUrl = portalUrl;
        this.sessionId = sessionId;
        this.cookie = "JSESSIONID=" + sessionId;
    }

    @Override
    public PortalUser getPortalUser() {
        String response = this.doGet(USER_SERVICE_PATH);
        return PortalUserContext.deserialize((String)response);
    }

    @Override
    public void publish(String news) {
        News newsBean = new News(news);
        String json = newsBean.encoded();
        String response = this.doPost(NEWS_SERVICE_PATH, json);
        this.checkResponse(response);
    }

    private void checkResponse(String response) {
        if (SUCCESSFULL_RESPONSE.equals(response)) {
            throw new RuntimeException("Request failed, cause: " + response);
        }
    }

    private String doGet(String servicePath) {
        try {
            URL url = new URL(this.portalUrl + servicePath);
            return this.httpClient.get(url, this.cookie);
        }
        catch (Exception e) {
            logger.error("Request failed for service path " + servicePath, (Throwable)e);
            throw new RuntimeException("Request failed for service path " + servicePath, e);
        }
    }

    private String doPost(String servicePath, String request) {
        try {
            URL url = new URL(this.portalUrl + servicePath);
            return this.httpClient.post(url, this.cookie, request);
        }
        catch (Exception e) {
            logger.error("Request failed for service path " + servicePath, (Throwable)e);
            throw new RuntimeException("Request failed for service path " + servicePath, e);
        }
    }
}

