/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.gcube.extension;

import javax.enterprise.event.Observes;
import org.cotrix.action.events.CodelistActionEvents;
import org.cotrix.gcube.extension.PortalProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubePublisher {
    private Logger logger = LoggerFactory.getLogger(GCubePublisher.class);

    public void onImportEvent(@Observes CodelistActionEvents.Import importEvent) {
        this.logger.trace("onImportEvent event: {}", (Object)importEvent);
        try {
            PortalProxy portalProxy = (PortalProxy)importEvent.session.get(PortalProxy.class);
            portalProxy.publish(importEvent.codelistName + " version " + importEvent.codelistVersion + " now available.");
        }
        catch (Exception e) {
            this.logger.error("Failed news propagation", (Throwable)e);
        }
    }

    public void onPublishEvent(@Observes CodelistActionEvents.Publish publishEvent) {
        this.logger.trace("onPublishEvent event: {}", (Object)publishEvent);
        try {
            PortalProxy portalProxy = (PortalProxy)publishEvent.session.get(PortalProxy.class);
            portalProxy.publish(publishEvent.codelistName + " version " + publishEvent.codelistVersion + " has just been published to " + publishEvent.repository + ".");
        }
        catch (Exception e) {
            this.logger.error("Failed news propagation", (Throwable)e);
        }
    }

    public void onVersionEvent(@Observes CodelistActionEvents.Version versionEvent) {
        this.logger.trace("onVersionEvent event: {}", (Object)versionEvent);
        try {
            PortalProxy portalProxy = (PortalProxy)versionEvent.session.get(PortalProxy.class);
            portalProxy.publish("version " + versionEvent.codelistVersion + " of " + versionEvent.codelistName + " now available.");
        }
        catch (Exception e) {
            this.logger.error("Failed news propagation", (Throwable)e);
        }
    }
}

