/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.gcube.extension;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.common.BeanSession;
import org.cotrix.common.events.ApplicationLifecycleEvents;
import org.cotrix.common.events.Current;
import org.cotrix.domain.user.User;
import org.cotrix.gcube.stubs.SessionToken;
import org.gcube.common.scope.api.ScopeProvider;
import org.virtualrepository.CommonProperties;
import org.virtualrepository.Context;
import org.virtualrepository.Property;

@Singleton
public class RequestLifecycle {
    @Inject
    @Current
    private BeanSession session;

    void onStartRequest(@Observes ApplicationLifecycleEvents.StartRequest start) {
        if (this.session.contains(SessionToken.class)) {
            this.init((SessionToken)this.session.get(SessionToken.class), (User)this.session.get(User.class));
        }
    }

    void onEndRequest(@Observes ApplicationLifecycleEvents.EndRequest end) {
        this.stop();
    }

    public void init(SessionToken token, User user) {
        Context.properties().add(new Property[]{CommonProperties.USERNAME.property(user.name())});
        ScopeProvider.instance.set(token.scope());
    }

    public void stop() {
        ScopeProvider.instance.reset();
    }
}

