/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.sdmx.map;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cotrix.common.Utils;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.io.MapService;
import org.cotrix.io.sdmx.Constants;
import org.cotrix.io.sdmx.SdmxElement;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;

public class Codelist2SdmxDirectives
implements MapService.MapDirectives<CodelistBean> {
    public static Codelist2SdmxDirectives DEFAULT = new Codelist2SdmxDirectives();
    private static Map<QName, SdmxElement> defaults = new HashMap<QName, SdmxElement>();
    private final Map<Attribute, SdmxElement> attributeDirectives = new HashMap<Attribute, SdmxElement>();
    private String agency = Constants.DEFAULT_SDMX_AGENCY;
    private String name;
    private String version;
    private Boolean isFinal;

    public void name(String name) {
        this.name = name;
    }

    public Boolean isFinal() {
        return this.isFinal;
    }

    public void isFinal(Boolean isfinal) {
        this.isFinal = isfinal;
    }

    public String name() {
        return this.name;
    }

    public String agency() {
        return this.agency;
    }

    public void agency(String agency) {
        this.agency = agency;
    }

    public void version(String version) {
        this.version = version;
    }

    public String version() {
        return this.version;
    }

    public SdmxElement get(Attribute attribute) {
        SdmxElement element = this.attributeDirectives.get(this.canonicalFormOf(attribute));
        if (element == null && attribute.type() != null) {
            element = defaults.get(attribute.type());
        }
        return element;
    }

    public MappingClause map(final QName name, final QName type) {
        Utils.notNull((String)"name", (Object)name);
        Utils.notNull((String)"type", (Object)type);
        return new MappingClause(){

            @Override
            public Codelist2SdmxDirectives to(SdmxElement element) {
                Utils.notNull((String)"SDMX element", (Object)((Object)element));
                Codelist2SdmxDirectives.this.attributeDirectives.put(Codelist2SdmxDirectives.this.templateFrom(name, type), element);
                return Codelist2SdmxDirectives.this;
            }
        };
    }

    public MappingClause map(String name, String type) {
        Utils.notNull((String)"name", (Object)name);
        Utils.notNull((String)"type", (Object)type);
        return this.map(Codes.q((String)name), Codes.q((String)type));
    }

    public Attribute canonicalFormOf(Attribute a) {
        return this.templateFrom(a.name(), a.type());
    }

    public Attribute templateFrom(QName name, QName type) {
        return (Attribute)((AttributeGrammar.ValueClause)Codes.modifyAttribute((String)"*").name(name)).value("?").ofType(type).build();
    }

    static {
        for (SdmxElement e : SdmxElement.values()) {
            defaults.put(e.defaultType(), e);
        }
    }

    public static interface MappingClause {
        public Codelist2SdmxDirectives to(SdmxElement var1);
    }
}

