/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.tabular.map;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.cotrix.common.Report;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.io.tabular.map.Column2Attribute;
import org.cotrix.io.tabular.map.ColumnDirectives;
import org.cotrix.io.tabular.map.Table2CodelistDirectives;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;

public class Table2Codelist {
    private final List<Code> codes = new ArrayList<Code>();
    private final List<Column2Attribute> attributeMappers = new ArrayList<Column2Attribute>();
    private final Table2CodelistDirectives directives;

    public Table2Codelist(Table2CodelistDirectives directives) {
        this.directives = directives;
        for (ColumnDirectives attributeMapping : directives.columns()) {
            this.attributeMappers.add(new Column2Attribute(attributeMapping));
        }
    }

    public Table2CodelistDirectives mapping() {
        return this.directives;
    }

    public Codelist apply(Table table) {
        double time = System.currentTimeMillis();
        Report.report().log("mapping table to codelist " + this.directives.name());
        Report.report().log(Calendar.getInstance().getTime().toString());
        Report.report().log("==============================");
        for (Row row : table) {
            this.map(row);
        }
        Codelist list = this.list();
        Report.report().log("==============================");
        Report.report().log("mapped table to codelist '" + this.directives.name() + "' with " + list.codes().size() + " codes in " + ((double)System.currentTimeMillis() - time) / 1000.0);
        return list;
    }

    void map(Row row) {
        String name = row.get(this.directives.codeColumn());
        if (!this.valid(name)) {
            return;
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Column2Attribute attributeMapper : this.attributeMappers) {
            Attribute parsed = attributeMapper.map(name, row);
            if (parsed == null) continue;
            attributes.add(parsed);
        }
        Code code = (Code)((CodeGrammar.FinalClause)((CodeGrammar.SecondClause)Codes.code().name(name)).attributes(attributes.toArray(new Attribute[0]))).build();
        this.codes.add(code);
    }

    Codelist list() {
        boolean hasVersion = this.directives.version() != null;
        CodelistGrammar.FinalClause clause = (CodelistGrammar.FinalClause)((CodelistGrammar.ThirdClause)((CodelistGrammar.SecondClause)Codes.codelist().name(this.directives.name())).with((Object[])this.codes.toArray(new Code[0]))).attributes(this.directives.attributes().toArray(new Attribute[0]));
        return hasVersion ? (Codelist)clause.version(this.directives.version()).build() : (Codelist)clause.build();
    }

    private boolean valid(String value) {
        if (value == null || value.isEmpty()) {
            String msg = "missing code in '" + this.directives.name() + "'";
            switch (this.directives.mode()) {
                case STRICT: {
                    Report.report().logError(msg);
                    break;
                }
                case LOG: {
                    Report.report().logWarning(msg);
                }
            }
            return false;
        }
        return true;
    }
}

