/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.sdmx.map;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cotrix.common.Utils;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.io.MapService;
import org.cotrix.io.sdmx.Constants;
import org.cotrix.io.sdmx.SdmxElement;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;

public class Codelist2SdmxDirectives
implements MapService.MapDirectives<CodelistBean> {
    public static Codelist2SdmxDirectives DEFAULT = new Codelist2SdmxDirectives();
    private final Map<AttributeTemplate, SdmxElement> attributeDirectives = new HashMap<AttributeTemplate, SdmxElement>();
    private final Map<AttributeTemplate, SdmxElement> codelistAttributeDirectives = new HashMap<AttributeTemplate, SdmxElement>();
    private String agency = Constants.DEFAULT_SDMX_AGENCY;
    private String name;
    private String version;
    private Boolean isFinal;

    public void name(String name) {
        this.name = name;
    }

    public Boolean isFinal() {
        return this.isFinal;
    }

    public void isFinal(Boolean isfinal) {
        this.isFinal = isfinal;
    }

    public String name() {
        return this.name;
    }

    public String agency() {
        return this.agency;
    }

    public void agency(String agency) {
        this.agency = agency;
    }

    public void version(String version) {
        this.version = version;
    }

    public String version() {
        return this.version;
    }

    public GetClause forCodelist() {
        return new GetClause(){

            @Override
            public SdmxElement get(Attribute a) {
                return (SdmxElement)((Object)Codelist2SdmxDirectives.this.codelistAttributeDirectives.get(Codelist2SdmxDirectives.template(a)));
            }
        };
    }

    public GetClause forCodes() {
        return new GetClause(){

            @Override
            public SdmxElement get(Attribute a) {
                return (SdmxElement)((Object)Codelist2SdmxDirectives.this.attributeDirectives.get(Codelist2SdmxDirectives.template(a)));
            }
        };
    }

    public MappingClause map(final QName name, final QName type) {
        Utils.notNull((String)"name", (Object)name);
        Utils.notNull((String)"type", (Object)type);
        return new MappingClause(){

            @Override
            public TargetClause to(final SdmxElement element) {
                Utils.notNull((String)"SDMX element", (Object)((Object)element));
                return new TargetClause(){

                    @Override
                    public Codelist2SdmxDirectives forCodes() {
                        Codelist2SdmxDirectives.this.attributeDirectives.put(Codelist2SdmxDirectives.template(name, type), element);
                        return Codelist2SdmxDirectives.this;
                    }

                    @Override
                    public Codelist2SdmxDirectives forCodelist() {
                        Codelist2SdmxDirectives.this.codelistAttributeDirectives.put(Codelist2SdmxDirectives.template(name, type), element);
                        return Codelist2SdmxDirectives.this;
                    }
                };
            }
        };
    }

    public MappingClause map(String name, String type) {
        Utils.notNull((String)"name", (Object)name);
        Utils.notNull((String)"type", (Object)type);
        return this.map(Codes.q((String)name), Codes.q((String)type));
    }

    static AttributeTemplate template(Attribute a) {
        return Codelist2SdmxDirectives.template(a.name(), a.type());
    }

    static AttributeTemplate template(QName name, QName type) {
        AttributeTemplate template = new AttributeTemplate();
        template.name = name;
        template.type = type;
        return template;
    }

    static class AttributeTemplate {
        QName name;
        QName type;

        AttributeTemplate() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttributeTemplate other = (AttributeTemplate)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    public static interface MappingClause {
        public TargetClause to(SdmxElement var1);
    }

    public static interface TargetClause {
        public Codelist2SdmxDirectives forCodelist();

        public Codelist2SdmxDirectives forCodes();
    }

    public static interface GetClause {
        public SdmxElement get(Attribute var1);
    }
}

