/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.tabular.map;

import org.cotrix.common.Report;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.io.tabular.map.ColumnDirectives;
import org.cotrix.io.utils.SharedDefinitionPool;
import org.virtualrepository.tabular.Row;

public class Column2Attribute {
    private final ColumnDirectives mapping;

    public Column2Attribute(ColumnDirectives mapping) {
        this.mapping = mapping;
    }

    public Attribute map(String codename, Row row, SharedDefinitionPool defs) {
        String value = row.get(this.mapping.column());
        if (!this.valid(codename, value)) {
            return null;
        }
        Definition def = defs.get(this.mapping.name(), this.mapping.type(), this.mapping.language());
        return (Attribute)Codes.attribute().with(def).value(value).build();
    }

    private boolean valid(String codename, String value) {
        if (this.mapping.required() && (value == null || value.isEmpty())) {
            String msg = "code " + codename + " has no value for attribute '" + this.mapping.name() + "'";
            switch (this.mapping.mode()) {
                case STRICT: {
                    Report.report().log(msg).as(Report.Item.Type.ERROR);
                    break;
                }
                case LOG: {
                    Report.report().log(msg).as(Report.Item.Type.WARN);
                    break;
                }
            }
            return false;
        }
        return true;
    }
}

