/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.impl;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.namespace.QName;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.events.ApplicationLifecycleEvents;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.io.CloudService;
import org.fao.fi.comet.mapping.model.MappingData;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.virtualrepository.Asset;
import org.virtualrepository.AssetType;
import org.virtualrepository.Context;
import org.virtualrepository.Property;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.VirtualRepository;
import org.virtualrepository.comet.CometAsset;
import org.virtualrepository.csv.CsvCodelist;
import org.virtualrepository.sdmx.SdmxCodelist;
import org.virtualrepository.tabular.Table;

@Singleton
public class DefaultCloudService
implements Iterable<Asset>,
CloudService {
    public static final AssetType[] importTypes = new AssetType[]{SdmxCodelist.type, CsvCodelist.type};
    private final VirtualRepository repository;

    @Inject
    public DefaultCloudService(VirtualRepository repository) {
        this.repository = repository;
    }

    @Override
    public int discover() {
        return this.repository.discover(importTypes);
    }

    @Override
    public int discover(RepositoryService ... repositories) {
        return this.repository.discover(Arrays.asList(repositories), importTypes);
    }

    @Override
    public int discover(int timeout) {
        return this.repository.discover((long)timeout, importTypes);
    }

    @Override
    public int discover(int timeout, RepositoryService ... repositories) {
        return this.repository.discover((long)timeout, Arrays.asList(repositories), importTypes);
    }

    @Override
    public <T> T retrieve(String id, Class<T> type) {
        return (T)this.repository.retrieve(this.repository.lookup(id), type);
    }

    @Override
    public CodelistBean retrieveAsSdmx(String id) {
        return (CodelistBean)this.repository.retrieve(this.repository.lookup(id), CodelistBean.class);
    }

    @Override
    public Table retrieveAsTable(String id) {
        return (Table)this.repository.retrieve(this.repository.lookup(id), Table.class);
    }

    @Override
    public InputStream retrieveAsCsv(String id) {
        return (InputStream)this.repository.retrieve(this.repository.lookup(id), InputStream.class);
    }

    @Override
    public void publish(Codelist list, CodelistBean bean, QName name) {
        CommonUtils.notNull((String)"codelist", (Object)list);
        CommonUtils.notNull((String)"sdmx bean", (Object)bean);
        CommonUtils.notNull((String)"repository name", (Object)name);
        RepositoryService service = this.repository.services().lookup(name);
        SdmxCodelist asset = new SdmxCodelist(bean.getId(), service);
        this.repository.publish(this.describe(list, (Asset)asset), (Object)bean);
    }

    @Override
    public void publish(Codelist list, Table table, QName name) {
        CommonUtils.notNull((String)"codelist", (Object)list);
        CommonUtils.notNull((String)"table", (Object)table);
        CommonUtils.notNull((String)"repository name", (Object)name);
        RepositoryService service = this.repository.services().lookup(name);
        CsvCodelist asset = new CsvCodelist(list.qname().getLocalPart(), 0, service, new Property[0]);
        this.repository.publish(this.describe(list, (Asset)asset), (Object)table);
    }

    @Override
    public void publish(Codelist list, MappingData mapping, QName name) {
        CommonUtils.notNull((String)"codelist", (Object)list);
        CommonUtils.notNull((String)"mapping", (Object)mapping);
        CommonUtils.notNull((String)"repository name", (Object)name);
        RepositoryService service = this.repository.services().lookup(name);
        CometAsset asset = new CometAsset(list.qname().getLocalPart(), service, new Property[0]);
        this.repository.publish(this.describe(list, (Asset)asset), (Object)mapping);
    }

    private Asset describe(Codelist list, Asset asset) {
        for (Attribute attribute : list.attributes()) {
            asset.properties().add(new Property[]{new Property(attribute.qname().toString(), (Object)attribute.value())});
        }
        return asset;
    }

    @Override
    public Iterable<RepositoryService> repositories() {
        return this.repository.services();
    }

    @Override
    public Iterator<Asset> iterator() {
        return this.repository.iterator();
    }

    void onStartRequest(@Observes ApplicationLifecycleEvents.EndRequest end) {
        Context.reset();
    }
}

