/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.sdmx.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.trait.Defined;
import org.cotrix.domain.trait.Definition;
import org.cotrix.domain.utils.DomainUtils;
import org.cotrix.io.MapService;
import org.cotrix.io.sdmx.Constants;
import org.cotrix.io.sdmx.SdmxElement;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;

public class Codelist2SdmxDirectives
implements MapService.MapDirectives<CodelistBean> {
    public static Codelist2SdmxDirectives DEFAULT = new Codelist2SdmxDirectives();
    private final Map<String, SdmxElement> codelistDirectives = new HashMap<String, SdmxElement>();
    private final Map<SdmxElement, List<Definition>> codelistDefs = new HashMap<SdmxElement, List<Definition>>();
    private final Map<String, SdmxElement> codeDirectives = new HashMap<String, SdmxElement>();
    private final Map<SdmxElement, List<Definition>> codeDefs = new HashMap<SdmxElement, List<Definition>>();
    private String agency = Constants.DEFAULT_SDMX_AGENCY;
    private String id;
    private String version;
    private Boolean isFinal;
    private static String langError = "two or more attributes or links map onto %s with the same language";
    private static String noNameError = "no attribute or link maps onto a NAME for %s";

    public Codelist2SdmxDirectives id(String id) {
        this.id = id;
        return this;
    }

    public Boolean isFinal() {
        return this.isFinal;
    }

    public Codelist2SdmxDirectives isFinal(Boolean isfinal) {
        this.isFinal = isfinal;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String agency() {
        return this.agency;
    }

    public Codelist2SdmxDirectives agency(String agency) {
        this.agency = agency;
        return this;
    }

    public Codelist2SdmxDirectives version(String version) {
        this.version = version;
        return this;
    }

    public String version() {
        return this.version;
    }

    public GetClause forCodelist() {
        return new GetClause(){

            @Override
            public SdmxElement get(Defined<?> m) {
                return (SdmxElement)((Object)Codelist2SdmxDirectives.this.codelistDirectives.get(m.definition().id()));
            }
        };
    }

    public GetClause forCodes() {
        return new GetClause(){

            @Override
            public SdmxElement get(Defined<?> m) {
                return (SdmxElement)((Object)Codelist2SdmxDirectives.this.codeDirectives.get(m.definition().id()));
            }
        };
    }

    public MappingClause map(final Definition def) {
        CommonUtils.notNull((String)"mapping subject", (Object)def);
        return new MappingClause(){

            @Override
            public TargetClause to(final SdmxElement element) {
                CommonUtils.notNull((String)"SDMX element", (Object)((Object)element));
                return new TargetClause(){

                    @Override
                    public Codelist2SdmxDirectives forCodes() {
                        Codelist2SdmxDirectives.this.codeDirectives.put(def.id(), element);
                        if (Codelist2SdmxDirectives.this.codeDefs.get((Object)element) == null) {
                            Codelist2SdmxDirectives.this.codeDefs.put(element, new ArrayList());
                        }
                        ((List)Codelist2SdmxDirectives.this.codeDefs.get((Object)element)).add(def);
                        return Codelist2SdmxDirectives.this;
                    }

                    @Override
                    public Codelist2SdmxDirectives forCodelist() {
                        Codelist2SdmxDirectives.this.codelistDirectives.put(def.id(), element);
                        if (Codelist2SdmxDirectives.this.codelistDefs.get((Object)element) == null) {
                            Codelist2SdmxDirectives.this.codelistDefs.put(element, new ArrayList());
                        }
                        ((List)Codelist2SdmxDirectives.this.codelistDefs.get((Object)element)).add(def);
                        return Codelist2SdmxDirectives.this;
                    }
                };
            }
        };
    }

    public <T extends Definition> MappingClause map(Defined<T> m) {
        CommonUtils.notNull((String)"mapping subject", m);
        return this.map(m.definition());
    }

    public List<String> errors() {
        ArrayList<String> errors = new ArrayList<String>();
        List<Definition> names = this.codelistDefs.get((Object)SdmxElement.NAME);
        if (names == null || names.isEmpty()) {
            errors.add(String.format(noNameError, "the codelist"));
        }
        if ((names = this.codeDefs.get((Object)SdmxElement.NAME)) == null || names.isEmpty()) {
            errors.add(String.format(noNameError, "codes"));
        }
        this.addSingleLanguageErrors(errors, SdmxElement.NAME, this.codelistDefs.get((Object)SdmxElement.NAME));
        this.addSingleLanguageErrors(errors, SdmxElement.NAME, this.codeDefs.get((Object)SdmxElement.NAME));
        this.addSingleLanguageErrors(errors, SdmxElement.DESCRIPTION, this.codelistDefs.get((Object)SdmxElement.DESCRIPTION));
        this.addSingleLanguageErrors(errors, SdmxElement.DESCRIPTION, this.codeDefs.get((Object)SdmxElement.DESCRIPTION));
        return errors;
    }

    private void addSingleLanguageErrors(List<String> errors, SdmxElement element, List<Definition> defs) {
        if (defs == null || defs.isEmpty()) {
            return;
        }
        ArrayList<String> langs = new ArrayList<String>();
        for (Definition def : defs) {
            String lang = DomainUtils.languageOf((Definition)def);
            if (lang == null) {
                lang = "en";
            }
            if (langs.contains(lang)) {
                errors.add(String.format(langError, element.toString()));
                continue;
            }
            langs.add(lang);
        }
    }

    public static interface MappingClause {
        public TargetClause to(SdmxElement var1);
    }

    public static interface TargetClause {
        public Codelist2SdmxDirectives forCodelist();

        public Codelist2SdmxDirectives forCodes();
    }

    public static interface GetClause {
        public SdmxElement get(Defined<?> var1);
    }
}

