/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.sdmx.map;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.cotrix.common.Report;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.utils.DomainConstants;
import org.cotrix.io.impl.MapTask;
import org.cotrix.io.sdmx.SdmxElement;
import org.cotrix.io.sdmx.map.Sdmx2CodelistDirectives;
import org.cotrix.io.utils.SharedDefinitionPool;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.NameableBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;

public class Sdmx2Codelist
implements MapTask<CodelistBean, Codelist, Sdmx2CodelistDirectives> {
    @Override
    public Class<Sdmx2CodelistDirectives> directedBy() {
        return Sdmx2CodelistDirectives.class;
    }

    @Override
    public Codelist map(CodelistBean listbean, Sdmx2CodelistDirectives directives) throws Exception {
        Report.report().log("importing codelist '" + listbean.getId() + "'");
        Report.report().log("==============================");
        ArrayList<Object> codes = new ArrayList<Object>();
        SharedDefinitionPool pool = new SharedDefinitionPool();
        for (CodeBean codebean : listbean.getItems()) {
            codes.add(((CodeGrammar.SecondClause)((CodeGrammar.SecondClause)Data.code().name(codebean.getId())).attributes(this.attributesOf((NameableBean)codebean, pool, directives))).build());
        }
        String version = directives.version() == null ? listbean.getVersion() : directives.version();
        Codelist codelist = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Data.codelist().name(directives.name() == null ? new QName(listbean.getId()) : directives.name())).with(codes).definitions((Iterable)pool).attributes(this.from(listbean, directives))).version(version).build();
        Report.report().log("==============================");
        Report.report().log("terminated import of codelist '" + codelist.qname() + "' with " + codelist.codes().size() + " codes.");
        return codelist;
    }

    private Attribute attributeFor(QName name, QName type, TextTypeWrapper wrapper, SharedDefinitionPool pool) {
        return pool == null ? (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(name)).ofType(type).in(wrapper.getLocale()).value(wrapper.getValue()).build() : (Attribute)Data.attribute().instanceOf(pool.get(name, type, wrapper.getLocale())).value(wrapper.getValue()).build();
    }

    private List<Attribute> from(CodelistBean list, Sdmx2CodelistDirectives directives) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (directives.isIncluded(SdmxElement.FINAL)) {
            attributes.add((Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(directives.get(SdmxElement.FINAL))).value(String.valueOf(list.isFinal().isTrue())).build());
        }
        if (directives.isIncluded(SdmxElement.AGENCY)) {
            attributes.add((Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(directives.get(SdmxElement.AGENCY))).value(list.getAgencyId()).build());
        }
        if (directives.isIncluded(SdmxElement.VALID_FROM) && list.getStartDate() != null) {
            attributes.add((Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(directives.get(SdmxElement.VALID_FROM))).value(list.getStartDate().getDateInSdmxFormat()).build());
        }
        if (directives.isIncluded(SdmxElement.VALID_TO) && list.getEndDate() != null) {
            attributes.add((Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(directives.get(SdmxElement.VALID_TO))).value(list.getEndDate().getDateInSdmxFormat()).build());
        }
        if (directives.isIncluded(SdmxElement.URI) && list.getUri() != null) {
            attributes.add((Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(directives.get(SdmxElement.URI))).value(list.getUri().toString()).build());
        }
        attributes.addAll(this.attributesOf((NameableBean)list, directives));
        return attributes;
    }

    private List<Attribute> attributesOf(NameableBean bean, Sdmx2CodelistDirectives directives) {
        return this.attributesOf(bean, null, directives);
    }

    private List<Attribute> attributesOf(NameableBean bean, SharedDefinitionPool pool, Sdmx2CodelistDirectives directives) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (TextTypeWrapper name : bean.getNames()) {
            attributes.add(this.attributeFor(directives.get(SdmxElement.NAME), DomainConstants.NAME_TYPE, name, pool));
        }
        for (TextTypeWrapper description : bean.getDescriptions()) {
            attributes.add(this.attributeFor(directives.get(SdmxElement.DESCRIPTION), DomainConstants.DESCRIPTION_TYPE, description, pool));
        }
        for (AnnotationBean annotationBean : bean.getAnnotations()) {
            QName name = annotationBean.getId() == null ? (annotationBean.getTitle() == null ? directives.get(SdmxElement.NAME) : Data.q((String)annotationBean.getTitle())) : Data.q((String)annotationBean.getId());
            QName type = annotationBean.getType() == null ? DomainConstants.defaultType : Data.q((String)annotationBean.getType());
            for (TextTypeWrapper annotation : annotationBean.getText()) {
                attributes.add(this.attributeFor(name, type, annotation, pool));
            }
        }
        return attributes;
    }

    public String toString() {
        return "sdmx-2-codelist";
    }
}

