/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo;

import java.io.File;
import javax.annotation.Priority;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.cotrix.common.Utils;
import org.cotrix.common.cdi.ApplicationEvents;
import org.cotrix.common.cdi.ApplicationLifecycle;
import org.cotrix.common.cdi.Current;
import org.cotrix.neo.NeoConfiguration;
import org.cotrix.neo.domain.Constants;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Priority(value=1000)
public class NeoLifecycle {
    private static Logger log = LoggerFactory.getLogger(NeoLifecycle.class);
    private boolean newstore = true;

    @Produces
    @Alternative
    @Singleton
    GraphDatabaseService store(@Current NeoConfiguration config) {
        File dir = new File(config.location());
        if (dir.exists()) {
            Utils.validDirectory((File)dir);
        } else if (!dir.mkdirs()) {
            throw new RuntimeException("cannot create directory @ location " + config.location());
        }
        this.newstore = dir.list().length == 0;
        GraphDatabaseService store = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(config.location()).setConfig(config.properties()).newGraphDatabase();
        if (this.newstore) {
            log.info("creating Neo store @ {}", (Object)config.location());
            this.init(store);
        } else {
            log.info("restarting Neo store @ {}", (Object)config.location());
        }
        return store;
    }

    void onStart(@Observes ApplicationEvents.Startup event, ApplicationLifecycle app) {
        if (!this.newstore) {
            app.isRestart();
        }
    }

    public void init(GraphDatabaseService store) {
        log.info("creating Neo indices");
        try (Transaction tx = store.beginTx();){
            store.schema().indexFor((Label)Constants.NodeType.IDENTITY).on("name").create();
            store.schema().indexFor((Label)Constants.NodeType.CODELIST).on("id").create();
            store.schema().indexFor((Label)Constants.NodeType.USER).on("name").create();
            store.schema().indexFor((Label)Constants.NodeType.LIFECYCLE).on("id").create();
            tx.success();
        }
    }

    @Produces
    static ExecutionEngine engine(GraphDatabaseService store) {
        return new ExecutionEngine(store);
    }

    static void shutdown(@Observes ApplicationEvents.Shutdown event, GraphDatabaseService store, @Current NeoConfiguration config) {
        log.info("stopping Neo store @ {}", (Object)config.location());
        store.shutdown();
    }
}

