/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.lifecycle;

import com.thoughtworks.xstream.XStream;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.lifecycle.Lifecycle;
import org.cotrix.lifecycle.State;
import org.cotrix.lifecycle.impl.LifecycleRepository;
import org.cotrix.neo.domain.Constants;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

@Singleton
@Alternative
@Priority(value=1000)
public class NeoLifecycleRepository
implements LifecycleRepository {
    private static XStream stream = new XStream();
    @Inject
    private GraphDatabaseService store;

    public void add(Lifecycle lc) {
        Node node = this.store.createNode(new Label[]{Constants.NodeType.LIFECYCLE});
        node.setProperty("name", (Object)lc.name());
        node.setProperty("id", (Object)lc.resourceId());
        node.setProperty("state", (Object)stream.toXML((Object)lc.state()));
    }

    public LifecycleRepository.ResumptionToken lookup(String id) {
        Node node = this.nodeFor(id);
        if (node == null) {
            return null;
        }
        String name = (String)node.getProperty("name");
        State state = (State)stream.fromXML((String)node.getProperty("state"));
        return new LifecycleRepository.ResumptionToken(name, state);
    }

    public void update(Lifecycle lc) {
        Node node = this.nodeFor(lc.resourceId());
        if (node == null) {
            throw new AssertionError((Object)("attempt to update transient lifecycle " + lc.resourceId()));
        }
        node.setProperty("state", (Object)stream.toXML((Object)lc.state()));
    }

    private Node nodeFor(String id) {
        try (ResourceIterator retrieved = this.store.findNodesByLabelAndProperty((Label)Constants.NodeType.LIFECYCLE, "id", (Object)id).iterator();){
            Node node = retrieved.hasNext() ? (Node)retrieved.next() : null;
            return node;
        }
    }
}

