/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.repository;

import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.neo.NeoUtils;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoCodelist;
import org.cotrix.neo.repository.NeoCodelistQueries;
import org.cotrix.repository.spi.StateRepository;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

@ApplicationScoped
@Alternative
@Priority(value=1000)
public class NeoCodelistRepository
implements StateRepository<Codelist.State> {
    @Inject
    private GraphDatabaseService store;
    @Inject
    private NeoCodelistQueries queries;

    public void add(Codelist.State list) {
        new NeoCodelist(list);
    }

    public boolean contains(String id) {
        return this.nodeFor(id) != null;
    }

    public Codelist.State lookup(String id) {
        Node node = this.nodeFor(id);
        return node == null ? null : new NeoCodelist(node);
    }

    public void remove(String id) {
        NeoUtils.remove(this.nodeFor(id));
    }

    public int size() {
        return (Integer)this.queries.repositorySize(Constants.NodeType.CODELIST).execute();
    }

    private Node nodeFor(String id) {
        try (ResourceIterator retrieved = this.store.findNodesByLabelAndProperty((Label)Constants.NodeType.CODELIST, "id", (Object)id).iterator();){
            Node node = retrieved.hasNext() ? (Node)retrieved.next() : null;
            return node;
        }
    }
}

