/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.repository;

import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Singleton;
import org.cotrix.action.ResourceType;
import org.cotrix.domain.common.IteratorAdapter;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoUser;
import org.cotrix.neo.domain.utils.NeoBeanFactory;
import org.cotrix.neo.domain.utils.NeoNodeIterator;
import org.cotrix.neo.repository.NeoCriterion;
import org.cotrix.neo.repository.NeoMultiQuery;
import org.cotrix.neo.repository.NeoQueries;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.MultiQuery;
import org.cotrix.repository.Query;
import org.cotrix.repository.spi.UserQueryFactory;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

@Singleton
@Alternative
@Priority(value=1000)
public class NeoUserQueries
extends NeoQueries
implements UserQueryFactory {
    Iterator<User> users(ResourceIterator<Node> it) {
        return new IteratorAdapter(new NeoNodeIterator<User.State>((Iterator<Node>)it, (NeoBeanFactory<User.State>)NeoUser.factory));
    }

    public NeoMultiQuery<User, User> allUsers() {
        return new NeoMultiQuery<User, User>(this.engine){
            {
                this.match(String.format("(%1$s:%2$s)", "N", Constants.NodeType.USER.name()));
                this.rtrn(String.format("%1$s as %2$s", "N", "RESULT"));
            }

            public Iterator<User> iterator() {
                ExecutionResult result = this.executeNeo();
                ResourceIterator it = result.columnAs("RESULT");
                return NeoUserQueries.this.users((ResourceIterator<Node>)it);
            }
        };
    }

    public Query<User, User> userByName(final String name) {
        return new Query.Private<User, User>(){

            public User execute() {
                String query = String.format("MATCH (%1$s:%2$s) WHERE %1$s.name = '%3$s'  RETURN %1$s as %4$s", "N", Constants.NodeType.USER.name(), name, "RESULT");
                ExecutionResult result = NeoUserQueries.this.engine.execute(query);
                try (ResourceIterator it = result.columnAs("RESULT");){
                    User.Private private_ = it.hasNext() ? new NeoUser((Node)it.next()).entity() : null;
                    return private_;
                }
            }
        };
    }

    public MultiQuery<User, User> teamFor(final String codelistId) {
        return new NeoMultiQuery<User, User>(this.engine){

            public Iterator<User> iterator() {
                HashSet<User> matches = new HashSet<User>();
                for (User user : NeoUserQueries.this.allUsers().execute()) {
                    if (user.fingerprint().specificRolesOver(codelistId, ResourceType.codelists).isEmpty()) continue;
                    matches.add(user);
                }
                return matches.iterator();
            }
        };
    }

    public Criterion<User> byName() {
        return new NeoCriterion<User>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                return String.format("%1$s.%2$s", "N", "name");
            }
        };
    }

    public Criterion<User> byFullName() {
        return new NeoCriterion<User>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                return String.format("%1$s.%2$s", "N", "fullname");
            }
        };
    }

    public MultiQuery<User, User> usersWithRole(final Role role) {
        return new NeoMultiQuery<User, User>(this.engine){

            public Iterator<User> iterator() {
                HashSet<User> matches = new HashSet<User>();
                for (User user : NeoUserQueries.this.allUsers().execute()) {
                    if (!user.is(role)) continue;
                    matches.add(user);
                }
                return matches.iterator();
            }
        };
    }
}

