/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Singleton;
import org.cotrix.action.ResourceType;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.common.IteratorAdapter;
import org.cotrix.domain.user.FingerPrint;
import org.cotrix.domain.user.User;
import org.cotrix.domain.utils.Constants;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoCode;
import org.cotrix.neo.domain.NeoCodelist;
import org.cotrix.neo.domain.utils.NeoBeanFactory;
import org.cotrix.neo.domain.utils.NeoNodeIterator;
import org.cotrix.neo.repository.NeoCriterion;
import org.cotrix.neo.repository.NeoMultiQuery;
import org.cotrix.neo.repository.NeoQueries;
import org.cotrix.repository.CodelistCoordinates;
import org.cotrix.repository.CodelistSummary;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.MultiQuery;
import org.cotrix.repository.Query;
import org.cotrix.repository.spi.CodelistQueryFactory;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

@Singleton
@Alternative
@Priority(value=1000)
public class NeoCodelistQueries
extends NeoQueries
implements CodelistQueryFactory {
    public MultiQuery<Codelist, Codelist> allLists() {
        return new NeoMultiQuery<Codelist, Codelist>(this.engine){
            {
                this.match(String.format("(%1$s:%2$s)", "N", Constants.NodeType.CODELIST.name()));
                this.rtrn(String.format("%1$s as %2$s", "N", "RESULT"));
            }

            public Iterator<Codelist> iterator() {
                ExecutionResult result = this.executeNeo();
                ResourceIterator it = result.columnAs("RESULT");
                return NeoCodelistQueries.this.codelists((ResourceIterator<Node>)it);
            }
        };
    }

    public MultiQuery<Codelist, CodelistCoordinates> allListCoordinates() {
        return new NeoMultiQuery<Codelist, CodelistCoordinates>(this.engine){
            {
                this.match(String.format("(%1$s:%2$s)", "N", Constants.NodeType.CODELIST.name()));
                this.rtrn(String.format("%1$s as %2$s", "N", "RESULT"));
            }

            public Iterator<CodelistCoordinates> iterator() {
                ExecutionResult result = this.executeNeo();
                ResourceIterator it = result.columnAs("RESULT");
                return NeoCodelistQueries.this.coordinates((ResourceIterator<Node>)it);
            }
        };
    }

    public MultiQuery<Codelist, Code> allCodes(final String codelistId) {
        return new NeoMultiQuery<Codelist, Code>(this.engine){
            {
                super(x0);
                this.match(String.format("(L:%1$s {%2$s:'%3$s'})-[:%4$s]->(%5$s)", Constants.NodeType.CODELIST.name(), "id", codelistId, Constants.Relations.CODE.name(), "N"));
                this.rtrn(String.format("DISTINCT(%1$s) as %2$s", "N", "RESULT"));
            }

            public Iterator<Code> iterator() {
                ExecutionResult result = this.executeNeo();
                ResourceIterator it = result.columnAs("RESULT");
                return NeoCodelistQueries.this.codes((ResourceIterator<Node>)it);
            }
        };
    }

    public MultiQuery<Codelist, CodelistCoordinates> codelistsFor(User u) {
        final FingerPrint fp = u.fingerprint();
        return new NeoMultiQuery<Codelist, CodelistCoordinates>(this.engine){
            {
                super(x0);
                this.match(String.format("(%1$s:%2$s)", "N", Constants.NodeType.CODELIST.name()));
                this.rtrn(String.format("%1$s as %2$s", "N", "RESULT"));
            }

            public Iterator<CodelistCoordinates> iterator() {
                ExecutionResult result = this.executeNeo();
                HashSet<CodelistCoordinates> coordinates = new HashSet<CodelistCoordinates>();
                try (ResourceIterator it = result.columnAs("RESULT");){
                    while (it.hasNext()) {
                        NeoCodelist state = new NeoCodelist((Node)it.next());
                        if (fp.allRolesOver(state.id(), ResourceType.codelists).isEmpty()) continue;
                        coordinates.add(CodelistCoordinates.coordsOf((Codelist.State)state));
                    }
                }
                return coordinates.iterator();
            }
        };
    }

    public Query<Codelist, CodelistSummary> summary(final String codelistId) {
        return new Query.Private<Codelist, CodelistSummary>(){

            public CodelistSummary execute() {
                String query = String.format("MATCH (%1$s:%2$s {%3$s:'%4$s'}) RETURN %1$s as %5$s", "N", Constants.NodeType.CODELIST.name(), "id", codelistId, "RESULT");
                ExecutionResult result = NeoCodelistQueries.this.engine.execute(query);
                NeoCodelist state = null;
                try (ResourceIterator it = result.columnAs("RESULT");){
                    if (!it.hasNext()) {
                        throw new IllegalStateException("no such codelist: " + codelistId);
                    }
                    state = new NeoCodelist((Node)it.next());
                }
                int size = state.codes().size();
                Codelist.Private list = state.entity();
                ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                for (Attribute a : list.attributes()) {
                    if (a.type().equals(Constants.SYSTEM_TYPE)) continue;
                    attributes.add(a);
                }
                HashMap fingerprint = new HashMap();
                for (Code c : list.codes()) {
                    CodelistSummary.addToFingerprint(fingerprint, (Iterable)c.attributes());
                }
                return new CodelistSummary(list.name(), size, attributes, fingerprint);
            }
        };
    }

    public Criterion<Codelist> byCodelistName() {
        return new NeoCriterion<Codelist>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                return String.format("%1$s.%2$s", "N", "name");
            }
        };
    }

    public Criterion<Code> byCodeName() {
        return new NeoCriterion<Code>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                return String.format("%1$s.%2$s", "N", "name");
            }
        };
    }

    public Criterion<CodelistCoordinates> byCoordinateName() {
        return this.byCodelistName();
    }

    public Criterion<Codelist> byVersion() {
        return new NeoCriterion<Codelist>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                return String.format("%1$s.%2$s", "N", "ver");
            }
        };
    }

    public Criterion<Code> byAttribute(final Attribute attribute, final int position) {
        return new NeoCriterion<Code>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                String $attribute = "A";
                query.match(String.format("%1$s-[:%2$s]->(%3$s)", "N", Constants.Relations.ATTRIBUTE.name(), $attribute));
                query.with("N");
                String caseTemplate = "CASE %1$s WHEN '%2$s' THEN %3$s END AS VAL ORDER BY VAL";
                String expression = attribute.language() == null ? String.format("%1$s.%2$s[%3$s]", $attribute, "name", position - 1) : String.format("%1$s.%2$s[%3$s]+%1$s.%4$s", $attribute, "name", position - 1, "lang");
                String value = attribute.language() == null ? attribute.name().toString() : attribute.name() + attribute.language();
                String caseValue = String.format("%1$s.%2$s", $attribute, "val");
                query.with(String.format(caseTemplate, expression, value, caseValue));
                return "";
            }
        };
    }

    Iterator<Codelist> codelists(ResourceIterator<Node> it) {
        return new IteratorAdapter(new NeoNodeIterator<Codelist.State>((Iterator<Node>)it, (NeoBeanFactory<Codelist.State>)NeoCodelist.factory));
    }

    Iterator<Code> codes(ResourceIterator<Node> it) {
        return new IteratorAdapter(new NeoNodeIterator<Code.State>((Iterator<Node>)it, (NeoBeanFactory<Code.State>)NeoCode.factory));
    }
}

