/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo;

import com.thoughtworks.xstream.XStream;
import javax.enterprise.event.Observes;
import org.cotrix.common.Utils;
import org.cotrix.common.cdi.ApplicationEvents;
import org.cotrix.neo.domain.Constants;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.cache.LruCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoUtils {
    private static final int thread_cache_size = 50;
    private static final Logger log = LoggerFactory.getLogger(NeoUtils.class);
    private static final XStream stream = new XStream();
    private static InheritableThreadLocal<LruCache<String, Node>> cache;

    public static void removeEntityNode(Node n) {
        Utils.notNull((String)"node", (Object)n);
        if (n.hasRelationship(Direction.INCOMING)) {
            throw new IllegalStateException("entity " + n.getProperty("id") + ":" + n.getLabels() + " cannot be removed: there are other entities that link to it, directly or indirectly");
        }
        NeoUtils.removeNode(n);
    }

    public static void removeNode(Node n) {
        Utils.notNull((String)"node", (Object)n);
        for (Relationship r : n.getRelationships(Direction.OUTGOING)) {
            if (r.isType((RelationshipType)Constants.Relations.LINK) || r.isType((RelationshipType)Constants.Relations.INSTANCEOF)) {
                r.delete();
                continue;
            }
            NeoUtils.removeNode(r.getEndNode());
        }
        for (Relationship r : n.getRelationships(Direction.INCOMING)) {
            r.delete();
        }
        for (Relationship r : n.getRelationships()) {
            r.delete();
            log.warn("force removed " + r.getType() + " on " + n.getLabels());
        }
        n.delete();
    }

    public static XStream binder() {
        return stream;
    }

    public static LruCache<String, Node> threadCache() {
        return (LruCache)cache.get();
    }

    static void prepareCaches(@Observes ApplicationEvents.Startup event) {
        cache = new InheritableThreadLocal<LruCache<String, Node>>(){

            @Override
            protected LruCache<String, Node> initialValue() {
                return new LruCache("thread-cache", 50);
            }
        };
        log.info("prepared thread caches");
    }

    static void detachCaches(@Observes ApplicationEvents.Shutdown event) {
        cache = null;
        log.info("detached thread caches");
    }
}

