/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo;

import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.cotrix.common.tx.Transaction;
import org.neo4j.graphdb.GraphDatabaseService;

@Alternative
@Priority(value=1000)
public class NeoTransaction
implements Transaction {
    private org.neo4j.graphdb.Transaction tx;
    private final GraphDatabaseService store;
    private static final InheritableThreadLocal<NeoTransaction> current = new InheritableThreadLocal();

    public static NeoTransaction current() {
        return (NeoTransaction)current.get();
    }

    @Inject
    public NeoTransaction(GraphDatabaseService store) {
        this.store = store;
        this.open();
    }

    void open() {
        this.tx = this.store.beginTx();
        current.set(this);
    }

    public void commit() {
        this.tx.success();
    }

    public void split() {
        this.commit();
        this.close();
        this.open();
    }

    public void close() {
        this.tx.close();
    }
}

