/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.repository;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Singleton;
import javax.xml.namespace.QName;
import org.cotrix.action.ResourceType;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.BeanIteratorAdapter;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.user.FingerPrint;
import org.cotrix.domain.user.User;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoCode;
import org.cotrix.neo.domain.NeoCodelist;
import org.cotrix.neo.domain.utils.NeoBeanFactory;
import org.cotrix.neo.domain.utils.NeoNodeIterator;
import org.cotrix.neo.repository.NeoCriterion;
import org.cotrix.neo.repository.NeoMultiQuery;
import org.cotrix.neo.repository.NeoQueries;
import org.cotrix.neo.repository.PostProcessingIterator;
import org.cotrix.repository.CodelistCoordinates;
import org.cotrix.repository.CodelistSummary;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.MultiQuery;
import org.cotrix.repository.Query;
import org.cotrix.repository.spi.CodelistQueryFactory;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

@Singleton
@Alternative
@Priority(value=1000)
public class NeoCodelistQueries
extends NeoQueries
implements CodelistQueryFactory {
    public MultiQuery<Codelist, Codelist> allLists() {
        return new NeoMultiQuery<Codelist, Codelist>(this.engine){
            {
                this.match(String.format("(%1$s:%2$s)", "N", Constants.NodeType.CODELIST.name()));
                this.rtrn(String.format("%1$s as %2$s", "N", "RESULT"));
            }

            public Iterator<Codelist> iterator() {
                ExecutionResult result = this.executeNeo();
                ResourceIterator it = result.columnAs("RESULT");
                return NeoCodelistQueries.this.codelists((ResourceIterator<Node>)it);
            }
        };
    }

    public MultiQuery<Codelist, CodelistCoordinates> allListCoordinates() {
        return new NeoMultiQuery<Codelist, CodelistCoordinates>(this.engine){
            {
                this.match(String.format("(%1$s:%2$s)", "N", Constants.NodeType.CODELIST.name()));
                this.rtrn(String.format("%1$s as %2$s", "N", "RESULT"));
            }

            public Iterator<CodelistCoordinates> iterator() {
                ExecutionResult result = this.executeNeo();
                ResourceIterator it = result.columnAs("RESULT");
                return NeoCodelistQueries.this.coordinates((ResourceIterator<Node>)it);
            }
        };
    }

    public MultiQuery<Codelist, Code> allCodes(final String codelistId) {
        return new NeoMultiQuery<Codelist, Code>(this.engine){
            {
                super(x0);
                this.match(String.format("(L:%1$s {%2$s:'%3$s'})-[:%4$s]->(%5$s)", Constants.NodeType.CODELIST.name(), "id", codelistId, Constants.Relations.CODE.name(), "N"));
                this.rtrn(String.format("DISTINCT %1$s as %2$s", "N", "RESULT"));
            }

            public Iterator<Code> iterator() {
                ExecutionResult result = this.executeNeo();
                ResourceIterator it = result.columnAs("RESULT");
                return NeoCodelistQueries.this.codes((Iterator<Node>)it);
            }
        };
    }

    public MultiQuery<Codelist, Code> codesChangedSince(final String codelistId, final Date date) {
        return new NeoMultiQuery<Codelist, Code>(this.engine){
            {
                super(x0);
                this.match(String.format("(L:%1$s {%2$s:'%3$s'})-[:%4$s]->(%5$s)", Constants.NodeType.CODELIST.name(), "id", codelistId, Constants.Relations.CODE.name(), "N"));
                this.rtrn(String.format("DISTINCT %1$s as %2$s", "N", "RESULT"));
            }

            public Iterator<Code> iterator() {
                this.query(this.query());
                ExecutionResult result = this.executeNeo();
                ResourceIterator nodes = result.columnAs("RESULT");
                PostProcessingIterator.PostProcessor<Code> processor = new PostProcessingIterator.PostProcessor<Code>(){

                    @Override
                    public boolean match(Code result) {
                        Date changed = CommonDefinition.LAST_UPDATED.dateOf((Described)result);
                        if (changed == null) {
                            changed = CommonDefinition.CREATED.dateOf((Described)result);
                        }
                        return changed != null && changed.after(date);
                    }
                };
                return new PostProcessingIterator<Code>(NeoCodelistQueries.this.codes((Iterator<Node>)nodes), this.range(), processor);
            }
        };
    }

    public MultiQuery<Codelist, Code> codesWithAttributes(final String codelistId, final Iterable<QName> names) {
        return new NeoMultiQuery<Codelist, Code>(this.engine){
            {
                super(x0);
                this.match(String.format("(L:CODELIST {id:'%1$s'})-[:CODE]->(C)", codelistId));
                for (QName name : names) {
                    this.match(String.format("(C)-[:%s]->()-[:%s]->({%s:'%s'})", Constants.Relations.ATTRIBUTE.name(), Constants.Relations.INSTANCEOF.name(), "name", name.toString()));
                }
                this.rtrn(String.format("DISTINCT C as %s", "RESULT"));
            }

            public Iterator<Code> iterator() {
                ExecutionResult result = this.executeNeo();
                ResourceIterator it = result.columnAs("RESULT");
                return NeoCodelistQueries.this.codes((Iterator<Node>)it);
            }
        };
    }

    public MultiQuery<Codelist, Code> codesWithCommonAttributes(final String codelistId, final Iterable<QName> names) {
        return new NeoMultiQuery<Codelist, Code>(this.engine){
            {
                super(x0);
                this.match(String.format("(L:CODELIST {id:'%1$s'})-[:CODE]->(C)", codelistId));
                for (QName name : names) {
                    this.match(String.format("(C)-[:%s]->({%s:'%s'})", Constants.Relations.ATTRIBUTE.name(), "cdef", name.getLocalPart().toString()));
                }
                this.rtrn(String.format("DISTINCT C as %s", "RESULT"));
            }

            public Iterator<Code> iterator() {
                ExecutionResult result = this.executeNeo();
                ResourceIterator it = result.columnAs("RESULT");
                return NeoCodelistQueries.this.codes((Iterator<Node>)it);
            }
        };
    }

    public MultiQuery<Codelist, Code> codes(final Collection<String> ids) {
        return new NeoMultiQuery<Codelist, Code>(this.engine){
            {
                super(x0);
                this.match(String.format("(C:%s)", Constants.NodeType.CODE.name()));
                StringBuilder builder = new StringBuilder();
                for (String id : ids) {
                    String element = String.format("'%s'", id);
                    builder.append(builder.length() == 0 ? element : "," + element);
                }
                String coll = builder.toString();
                this.where(String.format("C.%s IN [%s]", "id", coll));
                this.rtrn(String.format("DISTINCT C as %s", "RESULT"));
            }

            public Iterator<Code> iterator() {
                ExecutionResult result = this.executeNeo();
                ResourceIterator it = result.columnAs("RESULT");
                return NeoCodelistQueries.this.codes((Iterator<Node>)it);
            }
        };
    }

    public Query<Codelist, Code> code(final String id) {
        return new Query.Private<Codelist, Code>(){

            public Code execute() {
                String query = String.format("MATCH (C:%s {%s:'%s'}) RETURN C as %s", Constants.NodeType.CODE.name(), "id", id, "RESULT");
                ExecutionResult result = NeoCodelistQueries.this.engine.execute(query);
                NeoCode state = null;
                try (ResourceIterator it = result.columnAs("RESULT");){
                    if (!it.hasNext()) {
                        throw new IllegalStateException("no such code: " + id);
                    }
                    state = new NeoCode((Node)it.next());
                }
                return state.entity();
            }
        };
    }

    public MultiQuery<Codelist, CodelistCoordinates> codelistsFor(User u) {
        final FingerPrint fp = u.fingerprint();
        return new NeoMultiQuery<Codelist, CodelistCoordinates>(this.engine){
            {
                super(x0);
                this.match(String.format("(%1$s:%2$s)", "N", Constants.NodeType.CODELIST.name()));
                this.rtrn(String.format("%1$s as %2$s", "N", "RESULT"));
            }

            public Iterator<CodelistCoordinates> iterator() {
                ExecutionResult result = this.executeNeo();
                HashSet<CodelistCoordinates> coordinates = new HashSet<CodelistCoordinates>();
                try (ResourceIterator it = result.columnAs("RESULT");){
                    while (it.hasNext()) {
                        NeoCodelist state = new NeoCodelist((Node)it.next());
                        if (fp.allRolesOver(state.id(), ResourceType.codelists).isEmpty()) continue;
                        coordinates.add(CodelistCoordinates.coordsOf((Codelist.Bean)state));
                    }
                }
                return coordinates.iterator();
            }
        };
    }

    public Query<Codelist, CodelistSummary> summary(final String codelistId) {
        return new Query.Private<Codelist, CodelistSummary>(){

            public CodelistSummary execute() {
                String query = String.format("MATCH (%1$s:%2$s {%3$s:'%4$s'}) RETURN %1$s as %5$s", "N", Constants.NodeType.CODELIST.name(), "id", codelistId, "RESULT");
                ExecutionResult result = NeoCodelistQueries.this.engine.execute(query);
                NeoCodelist state = null;
                try (ResourceIterator it = result.columnAs("RESULT");){
                    if (!it.hasNext()) {
                        throw new IllegalStateException("no such codelist: " + codelistId);
                    }
                    state = new NeoCodelist((Node)it.next());
                }
                return new CodelistSummary((Codelist)state.entity());
            }
        };
    }

    public Criterion<Codelist> byCodelistName() {
        return new NeoCriterion<Codelist>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                return String.format("%1$s.%2$s", "N", "name");
            }
        };
    }

    public Criterion<Code> byCodeName() {
        return new NeoCriterion<Code>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                return String.format("%1$s.%2$s", "N", "name");
            }
        };
    }

    public Criterion<CodelistCoordinates> byCoordinateName() {
        return this.byCodelistName();
    }

    public Criterion<Codelist> byVersion() {
        return new NeoCriterion<Codelist>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                return String.format("%1$s.%2$s", "N", "ver");
            }
        };
    }

    public Criterion<Code> byAttribute(final Attribute template, final int position) {
        return new NeoCriterion<Code>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                query.match(String.format("%s-[:%s]->(A)", "N", Constants.Relations.ATTRIBUTE.name()));
                query.match(String.format("A-[:%s]->(T {name:'%s'})", Constants.Relations.INSTANCEOF.name(), template.qname()));
                query.with("N");
                String withTemplate = "[pair in COLLECT({val:A.val,lang:T.lang}) WHERE (%s) | %s ][%s] AS VAL ORDER BY VAL";
                String withCondition = template.language() == null ? "true" : String.format("pair.lang= '%s'", template.language());
                String projection = template.language() == null ? "pair.val" : "pair.val+pair.lang";
                query.with(String.format(withTemplate, withCondition, projection, position - 1));
                return "";
            }
        };
    }

    public Criterion<Code> byLink(final LinkDefinition template, final int position) {
        return new NeoCriterion<Code>(){

            @Override
            protected String process(NeoMultiQuery<?, ?> query) {
                query.match(String.format("%s-[:%s]->(L)", "N", Constants.Relations.LINK.name(), Constants.Relations.INSTANCEOF.name()));
                query.match(String.format("L-[:%s]->(LT)", position - 1, Constants.Relations.INSTANCEOF.name()));
                query.match(String.format("%s-[:%s]->(C)", new Object[]{Constants.Relations.LINK}));
                query.with("N");
                String caseTemplate = "CASE %s WHEN '%s' THEN %s END AS VAL ORDER BY VAL";
                String expression = String.format("LT.%s", "name", position - 1);
                String value = template.qname().toString();
                String caseValue = String.format("C.%s", "name");
                query.with(String.format(caseTemplate, expression, value, caseValue));
                return "";
            }
        };
    }

    Iterator<Codelist> codelists(ResourceIterator<Node> it) {
        return new BeanIteratorAdapter(new NeoNodeIterator<Codelist.Bean>((Iterator<Node>)it, (NeoBeanFactory<Codelist.Bean>)NeoCodelist.factory));
    }

    Iterator<Code> codes(Iterator<Node> it) {
        return new BeanIteratorAdapter(new NeoNodeIterator<Code.Bean>(it, NeoCode.factory));
    }
}

