/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.lifecycle;

import com.thoughtworks.xstream.XStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.common.CommonUtils;
import org.cotrix.lifecycle.Lifecycle;
import org.cotrix.lifecycle.State;
import org.cotrix.lifecycle.impl.LifecycleRepository;
import org.cotrix.neo.NeoNodeFactory;
import org.cotrix.neo.domain.Constants;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.tooling.GlobalGraphOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Alternative
@Priority(value=1000)
public class NeoLifecycleRepository
implements LifecycleRepository {
    private static Logger log = LoggerFactory.getLogger(NeoLifecycleRepository.class);
    private static XStream stream = new XStream();
    @Inject
    private GraphDatabaseService store;

    public void add(Lifecycle lc) {
        Node node = this.store.createNode(new Label[]{Constants.NodeType.LIFECYCLE});
        node.setProperty("name", (Object)lc.name());
        node.setProperty("id", (Object)lc.resourceId());
        node.setProperty("state", (Object)stream.toXML((Object)lc.state()));
    }

    public LifecycleRepository.ResumptionToken lookup(String id) {
        Node node = NeoNodeFactory.node(Constants.NodeType.LIFECYCLE, id);
        if (node == null) {
            return null;
        }
        return this.tokenFrom(node);
    }

    public Map<String, LifecycleRepository.ResumptionToken> lookup(Collection<String> ids) {
        HashMap<String, LifecycleRepository.ResumptionToken> tokens = new HashMap<String, LifecycleRepository.ResumptionToken>();
        try (ResourceIterator retrieved = GlobalGraphOperations.at((GraphDatabaseService)this.store).getAllNodesWithLabel((Label)Constants.NodeType.LIFECYCLE).iterator();){
            while (retrieved.hasNext()) {
                Node node = (Node)retrieved.next();
                tokens.put((String)node.getProperty("id"), this.tokenFrom(node));
            }
        }
        return tokens;
    }

    public void update(Lifecycle lc) {
        Node node = NeoNodeFactory.node(Constants.NodeType.LIFECYCLE, lc.resourceId());
        if (node == null) {
            log.warn("cannot update lifecycle for " + lc.resourceId() + " (maybe it has just been removed?)");
        } else {
            node.setProperty("state", (Object)stream.toXML((Object)lc.state()));
            log.info("updated {}'s lifecycle", (Object)lc.resourceId());
        }
    }

    public void delete(String id) {
        Node node = NeoNodeFactory.node(Constants.NodeType.LIFECYCLE, id);
        if (node == null) {
            log.warn("cannot remove lifecycle for {} (maybe it has already been removed?)", (Object)id);
            return;
        }
        try {
            node.delete();
        }
        catch (Exception e) {
            CommonUtils.rethrow((String)("cannot delete codelist lifecycle for " + id), (Throwable)e);
        }
        log.info("deleted {}'s lifecycle", (Object)id);
    }

    private LifecycleRepository.ResumptionToken tokenFrom(Node node) {
        String name = (String)node.getProperty("name");
        State state = (State)stream.fromXML((String)node.getProperty("state"));
        return new LifecycleRepository.ResumptionToken(name, state);
    }
}

