/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.xml.namespace.QName;
import org.cotrix.action.ResourceType;
import org.cotrix.common.Utils;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.user.FingerPrint;
import org.cotrix.domain.user.User;
import org.cotrix.domain.utils.Constants;
import org.cotrix.repository.CodelistCoordinates;
import org.cotrix.repository.CodelistSummary;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.MultiQuery;
import org.cotrix.repository.Query;
import org.cotrix.repository.impl.memory.MMultiQuery;
import org.cotrix.repository.impl.memory.MemoryRepository;
import org.cotrix.repository.spi.CodelistQueryFactory;

@ApplicationScoped
@Alternative
@Priority(value=1)
public class MCodelistRepository
extends MemoryRepository<Codelist.State>
implements CodelistQueryFactory {
    @Override
    public MultiQuery<Codelist, Codelist> allLists() {
        return new MMultiQuery<Codelist, Codelist>(){

            @Override
            Collection<Codelist> executeInMemory() {
                return MCodelistRepository.this.adapt(MCodelistRepository.this.getAll());
            }
        };
    }

    @Override
    public MultiQuery<Codelist, Code> allCodes(final String codelistId) {
        return new MMultiQuery<Codelist, Code>(){

            @Override
            public Collection<Code> executeInMemory() {
                ArrayList<Code.State> codes = new ArrayList<Code.State>();
                for (Code.State c : ((Codelist.State)MCodelistRepository.this.lookup(codelistId)).codes()) {
                    codes.add(c);
                }
                return MCodelistRepository.this.adapt(codes);
            }
        };
    }

    @Override
    public MultiQuery<Codelist, CodelistCoordinates> allListCoordinates() {
        return new MMultiQuery<Codelist, CodelistCoordinates>(){

            @Override
            public Collection<CodelistCoordinates> executeInMemory() {
                HashSet<CodelistCoordinates> coordinates = new HashSet<CodelistCoordinates>();
                for (Codelist.State list : MCodelistRepository.this.getAll()) {
                    coordinates.add(CodelistCoordinates.coordsOf(list));
                }
                return coordinates;
            }
        };
    }

    @Override
    public MultiQuery<Codelist, CodelistCoordinates> codelistsFor(User u) {
        final FingerPrint fp = u.fingerprint();
        return new MMultiQuery<Codelist, CodelistCoordinates>(){

            @Override
            public Collection<CodelistCoordinates> executeInMemory() {
                HashSet<CodelistCoordinates> coordinates = new HashSet<CodelistCoordinates>();
                for (Codelist.State list : MCodelistRepository.this.getAll()) {
                    if (fp.allRolesOver(list.id(), ResourceType.codelists).isEmpty()) continue;
                    coordinates.add(CodelistCoordinates.coordsOf(list));
                }
                return coordinates;
            }
        };
    }

    @Override
    public Query<Codelist, CodelistSummary> summary(final String id) {
        return new Query.Private<Codelist, CodelistSummary>(){

            @Override
            public CodelistSummary execute() {
                Codelist.State state = (Codelist.State)MCodelistRepository.this.lookup(id);
                if (state == null) {
                    throw new IllegalStateException("no such codelist: " + id);
                }
                int size = state.codes().size();
                Codelist list = (Codelist)state.entity();
                ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                for (Attribute a : list.attributes()) {
                    if (a.type().equals(Constants.SYSTEM_TYPE)) continue;
                    attributes.add(a);
                }
                HashMap<QName, Map<QName, Set<String>>> fingerprint = new HashMap<QName, Map<QName, Set<String>>>();
                for (Code c : list.codes()) {
                    CodelistSummary.addToFingerprint(fingerprint, (Iterable<? extends Attribute>)c.attributes());
                }
                return new CodelistSummary(list.name(), size, attributes, fingerprint);
            }
        };
    }

    @Override
    public Criterion<Codelist> byCodelistName() {
        return this.byName();
    }

    @Override
    public Criterion<Code> byCodeName() {
        return this.byName();
    }

    @Override
    public Criterion<CodelistCoordinates> byCoordinateName() {
        return this.byName();
    }

    private <T extends Named> Criterion<T> byName() {
        return new MemoryRepository.MCriterion<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.name().getLocalPart().compareTo(o2.name().getLocalPart());
            }
        };
    }

    @Override
    public Criterion<Codelist> byVersion() {
        return new MemoryRepository.MCriterion<Codelist>(){

            @Override
            public int compare(Codelist o1, Codelist o2) {
                return o1.version().compareTo(o2.version());
            }
        };
    }

    @Override
    public Criterion<Code> byAttribute(final Attribute attribute, final int position) {
        Utils.valid((String)"attribute name", (QName)attribute.name());
        return new MemoryRepository.MCriterion<Code>(){

            private boolean matches(Attribute a) {
                return attribute.name().equals(a.name()) && (attribute.language() == null || attribute.language().equals(a.language()));
            }

            @Override
            public int compare(Code c1, Code c2) {
                int pos = 1;
                String c1Match = null;
                for (Attribute a : c1.attributes()) {
                    if (!this.matches(a)) continue;
                    if (pos == position) {
                        c1Match = a.value();
                        break;
                    }
                    ++pos;
                }
                pos = 1;
                String c2Match = null;
                for (Attribute a : c2.attributes()) {
                    if (!this.matches(a)) continue;
                    if (pos == position) {
                        c2Match = a.value();
                        break;
                    }
                    ++pos;
                }
                if (c1Match == null) {
                    return c2Match == null ? 0 : 1;
                }
                return c2Match == null ? -1 : c1Match.compareTo(c2Match);
            }
        };
    }

    private static <R> MemoryRepository.MCriterion<R> reveal(Criterion<R> criterion) {
        return (MemoryRepository.MCriterion)Utils.reveal(criterion, MemoryRepository.MCriterion.class);
    }
}

