/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.inject.Inject;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelinkGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.dsl.grammar.CodelistLinkGrammar;
import org.cotrix.domain.dsl.grammar.CommonClauses;
import org.cotrix.domain.links.AttributeLink;
import org.cotrix.domain.links.NameLink;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Test;

public class CodelistRepositoryCrudTest
extends ApplicationTest {
    @Inject
    private CodelistRepository repository;

    @Test
    public void emptyRepo() {
        Assert.assertEquals((long)0L, (long)this.repository.size());
    }

    @Test
    public void retrieveUnknownCodeList() {
        Assert.assertNull((Object)this.repository.lookup("unknown"));
    }

    @Test
    public void retrieveCodelistWithLinks() {
        Code t1 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("target1")).build();
        Code t2 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("target2")).build();
        Codelist target = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("linked")).with((Object[])new Code[]{t1, t2})).build());
        CodelistLink listLink = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("link")).target((Object)target)).build();
        Codelist source = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("linking")).links((Object[])new CodelistLink[]{listLink})).build());
        t1 = (Code)target.codes().lookup(Codes.q((String)"target1"));
        t2 = (Code)target.codes().lookup(Codes.q((String)"target2"));
        listLink = (CodelistLink)source.links().lookup(Codes.q((String)"link"));
        Codelink link1 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)t1)).build();
        Codelink link2 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)t2)).build();
        Code s1 = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("target1")).links((Object[])new Codelink[]{link1})).build();
        Code s2 = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("target2")).links((Object[])new Codelink[]{link2})).build();
        Codelist changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)source.id()).with((Object[])new Code[]{s1, s2})).build();
        this.repository.update((Object)changeset);
        for (Code code : ((Codelist)this.repository.lookup(source.id())).codes()) {
            for (Codelink link : code.links()) {
                System.out.println(link.type().name() + ":" + link.value());
            }
        }
    }

    @Test
    public void addCodelist() {
        int size = this.repository.size();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build();
        this.repository.add((Object)list);
        Assert.assertEquals((long)(size + 1), (long)this.repository.size());
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertEquals((Object)list, (Object)retrieved);
    }

    @Test
    public void removeCode() {
        Code code = (Code)((CodeGrammar.OptionalClause)Codes.code().name("name")).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).with((Object[])new Code[]{code})).build();
        this.repository.add((Object)list);
        Assert.assertTrue((boolean)list.codes().contains((Object)code));
        this.repository.update(((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list.id()).with((Object[])new Code[]{Codes.deleteCode((String)code.id())})).build());
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertFalse((boolean)retrieved.codes().contains((Object)code));
    }

    @Test
    public void addCode() {
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build();
        this.repository.add((Object)list);
        list = (Codelist)this.repository.lookup(list.id());
        Code code = (Code)((CodeGrammar.OptionalClause)Codes.code().name("code")).build();
        Assert.assertFalse((boolean)list.codes().contains((Object)code));
        this.repository.update(((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list.id()).with((Object[])new Code[]{code})).build());
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertTrue((boolean)retrieved.codes().contains((Object)code));
    }

    @Test
    public void addListLink() {
        Codelist target = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build());
        CodelistLink link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("name")).target((Object)target)).build();
        Codelist list = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build());
        Codelist changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list.id()).links((Object[])new CodelistLink[]{link})).build();
        this.repository.update((Object)changeset);
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertEquals((Object)NameLink.INSTANCE, (Object)((CodelistLink)retrieved.links().lookup(Codes.q((String)"name"))).valueType());
    }

    @Test
    public void updateCode() {
        Code code = (Code)((CodeGrammar.OptionalClause)Codes.code().name("name")).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).with((Object[])new Code[]{code})).build();
        this.repository.add((Object)list);
        this.repository.update(((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list.id()).with((Object[])new Code[]{(Code)((CodeGrammar.OptionalClause)Codes.modifyCode((String)code.id()).name("name2")).build()})).build());
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertTrue((boolean)retrieved.codes().contains(Codes.q((String)"name2")));
    }

    @Test
    public void updateLinkName() {
        Codelist target = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build());
        CodelistLink link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("name")).target((Object)target)).build();
        Codelist list = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).links((Object[])new CodelistLink[]{link})).build());
        CodelistLink targetChangeset = (CodelistLink)((CodelistLinkGrammar.OptionalClause)Codes.modifyListLink((String)link.id()).name("name2")).build();
        Codelist changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list.id()).links((Object[])new CodelistLink[]{targetChangeset})).build();
        this.repository.update((Object)changeset);
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertTrue((boolean)retrieved.links().contains(Codes.q((String)"name2")));
    }

    @Test
    public void updateLinkTarget() {
        Codelist target = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name1")).build());
        CodelistLink link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("name")).target((Object)target)).build();
        Codelist list = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).links((Object[])new CodelistLink[]{link})).build());
        Attribute a = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("n")).value("v").build();
        CodelistLink linkChangeset = (CodelistLink)Codes.modifyListLink((String)link.id()).anchorTo(a).build();
        Codelist changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list.id()).links((Object[])new CodelistLink[]{linkChangeset})).build();
        this.repository.update((Object)changeset);
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertTrue((boolean)(((CodelistLink)retrieved.links().lookup(Codes.q((String)"name"))).valueType() instanceof AttributeLink));
    }

    @Test
    public void updateAttribute() {
        Attribute a = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name("n")).value("v").build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("n")).attributes(new Attribute[]{a})).build();
        this.repository.add((Object)list);
        Attribute modified = (Attribute)Codes.modifyAttribute((String)a.id()).value("v2").build();
        Codelist changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list.id()).attributes(new Attribute[]{modified})).build();
        this.repository.update((Object)changeset);
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertEquals((Object)((Attribute)retrieved.attributes().lookup(Codes.q((String)"n"))).value(), (Object)"v2");
    }

    @Test
    public void removeLink() {
        Codelist target = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build());
        CodelistLink link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("name")).target((Object)target)).build();
        Codelist list = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).links((Object[])new CodelistLink[]{link})).build());
        CodelistLink targetChangeset = Codes.deleteListLink((String)link.id());
        Codelist changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list.id()).links((Object[])new CodelistLink[]{targetChangeset})).build();
        this.repository.update((Object)changeset);
        Assert.assertFalse((boolean)list.links().contains(Codes.q((String)"name2")));
    }

    @Test
    public void removeCodelist() {
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build();
        this.repository.add((Object)list);
        int size = this.repository.size();
        this.repository.remove(list.id());
        Assert.assertEquals((long)(size - 1), (long)this.repository.size());
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertNull((Object)retrieved);
    }

    @Test(expected=CodelistRepository.UnremovableCodelistException.class)
    public void codelistCannotBeRemovedIfOthersLinkToIt() {
        Codelist list = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build());
        CodelistLink link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("name")).target((Object)list)).build();
        this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).links((Object[])new CodelistLink[]{link})).build());
        this.repository.remove(list.id());
    }

    @Test
    public void removeLinkingCodelistDoesNotRemoveLinkedCodelist() {
        Codelist list = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build());
        CodelistLink link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("name")).target((Object)list)).build();
        Codelist ref = this.addAndRetrieve((Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).links((Object[])new CodelistLink[]{link})).build());
        this.repository.remove(ref.id());
        Assert.assertNotNull((Object)this.repository.lookup(list.id()));
    }

    @Test(expected=IllegalStateException.class)
    public void removeUnknownCodelist() {
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build();
        this.repository.remove(list.id());
    }

    private Codelist addAndRetrieve(Codelist list) {
        this.repository.add((Object)list);
        return (Codelist)this.repository.lookup(list.id());
    }
}

