/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.links.AttributeLink;
import org.cotrix.domain.links.ValueType;
import org.cotrix.domain.utils.AttributeTemplate;
import org.cotrix.domain.utils.Constants;

public class CodelistSummary {
    private final QName name;
    private final int size;
    private final Collection<String> allLanguages = new HashSet<String>();
    private final Collection<QName> allTypes = new HashSet<QName>();
    private final Collection<QName> allNames = new HashSet<QName>();
    private final Map<QName, Map<QName, Set<String>>> codelistFingerprint;
    private final Map<QName, Map<QName, Set<String>>> fingerprint;
    private final Map<QName, Map<QName, Set<String>>> globalFingerprint;

    public CodelistSummary(QName name, int size, Collection<Attribute> attributes, Collection<CodelistLink> links, Map<QName, Map<QName, Set<String>>> fingerprint) {
        this.name = name;
        this.size = size;
        this.fingerprint = fingerprint;
        this.codelistFingerprint = new HashMap<QName, Map<QName, Set<String>>>();
        this.globalFingerprint = new HashMap<QName, Map<QName, Set<String>>>();
        CodelistSummary.addAttributesToFingerprint(this.globalFingerprint, attributes);
        CodelistSummary.addAttributesToFingerprint(this.codelistFingerprint, attributes);
        CodelistSummary.addLinksToFingerprint(this.globalFingerprint, links);
        for (QName n : fingerprint.keySet()) {
            this.allNames.add(n);
            for (Map<QName, Set<String>> typeMap : fingerprint.values()) {
                this.allTypes.addAll(typeMap.keySet());
                for (Set<String> ls : typeMap.values()) {
                    this.allLanguages.addAll(ls);
                }
            }
        }
        for (QName n : this.globalFingerprint.keySet()) {
            this.allNames.add(n);
            for (Map<QName, Set<String>> typeMap : this.globalFingerprint.values()) {
                this.allTypes.addAll(typeMap.keySet());
                for (Set<String> ls : typeMap.values()) {
                    this.allLanguages.addAll(ls);
                }
            }
        }
    }

    public QName name() {
        return this.name;
    }

    public int size() {
        return this.size;
    }

    public Collection<String> allLanguages() {
        return this.allLanguages;
    }

    public Collection<QName> allTypes() {
        return this.allTypes;
    }

    public Collection<QName> allNames() {
        return this.allNames;
    }

    public Collection<String> codeLanguagesFor(QName name, QName type) {
        if (this.fingerprint.containsKey(name) && this.fingerprint.get(name).containsKey(type)) {
            return this.fingerprint.get(name).get(type);
        }
        return Collections.emptySet();
    }

    public Collection<String> codelistLanguagesFor(QName name, QName type) {
        if (this.codelistFingerprint.containsKey(name) && this.codelistFingerprint.get(name).containsKey(type)) {
            return this.codelistFingerprint.get(name).get(type);
        }
        return Collections.emptySet();
    }

    public Collection<QName> allTypesFor(QName name) {
        HashSet<QName> values = new HashSet<QName>();
        Map<QName, Set<String>> typeMap = this.globalFingerprint.get(name);
        if (typeMap != null) {
            values.addAll(typeMap.keySet());
        }
        if ((typeMap = this.fingerprint.get(name)) != null) {
            values.addAll(typeMap.keySet());
        }
        return values;
    }

    public Collection<String> allLanguagesFor(QName name, QName type) {
        HashSet<String> values = new HashSet<String>();
        if (this.globalFingerprint.containsKey(name) && this.globalFingerprint.get(name).containsKey(type)) {
            values.addAll((Collection<String>)this.globalFingerprint.get(name).get(type));
        }
        if (this.fingerprint.containsKey(name) && this.fingerprint.get(name).containsKey(type)) {
            values.addAll((Collection<String>)this.fingerprint.get(name).get(type));
        }
        return values;
    }

    public Collection<QName> codeNames() {
        return this.fingerprint.keySet();
    }

    public Collection<QName> codelistNames() {
        return this.codelistFingerprint.keySet();
    }

    public Collection<QName> codeTypesFor(QName name) {
        return this.fingerprint.get(name).keySet();
    }

    public Collection<QName> codelistTypesFor(QName name) {
        return this.codelistFingerprint.get(name).keySet();
    }

    public static void addAttributesToFingerprint(Map<QName, Map<QName, Set<String>>> fingerprint, Iterable<? extends Attribute> attributes) {
        for (Attribute attribute : attributes) {
            CodelistSummary.addAttributeToFingerprint(fingerprint, attribute);
        }
    }

    public static void addLinksToFingerprint(Map<QName, Map<QName, Set<String>>> fingerprint, Iterable<? extends CodelistLink> links) {
        for (CodelistLink codelistLink : links) {
            CodelistSummary.addLinkToFingerprint(fingerprint, codelistLink);
        }
    }

    private static void addAttributeToFingerprint(Map<QName, Map<QName, Set<String>>> fingerprint, Attribute a) {
        if (a.type().equals(Constants.SYSTEM_TYPE)) {
            return;
        }
        CodelistSummary.addTo(CodelistSummary.typesForName(fingerprint, a.name()), a.type(), a.language());
    }

    private static void addLinkToFingerprint(Map<QName, Map<QName, Set<String>>> fingerprint, CodelistLink l) {
        Map<QName, Set<String>> types = CodelistSummary.typesForName(fingerprint, l.name());
        ValueType type = l.valueType();
        if (type instanceof AttributeLink) {
            AttributeTemplate template = ((AttributeLink)type).template();
            CodelistSummary.addTo(types, template.type(), template.language());
        }
    }

    private static Map<QName, Set<String>> typesForName(Map<QName, Map<QName, Set<String>>> fingerprint, QName name) {
        Map<QName, Set<String>> types = fingerprint.get(name);
        if (types == null) {
            types = new HashMap<QName, Set<String>>();
            fingerprint.put(name, types);
        }
        return types;
    }

    private static void addTo(Map<QName, Set<String>> types, QName type, String language) {
        Set<String> langForType = types.get(type);
        if (langForType == null) {
            langForType = new HashSet<String>();
            types.put(type, langForType);
        }
        if (language != null) {
            langForType.add(language);
        }
    }
}

