/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository;

import java.util.Collection;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.repository.impl.Fingerprint;

public class CodelistSummary {
    private final QName name;
    private final int size;
    private final Fingerprint codelistFingerprint;
    private final Fingerprint codeFingerprint;

    public CodelistSummary(Codelist list) {
        this.name = list.qname();
        this.size = list.codes().size();
        this.codeFingerprint = new Fingerprint().addDefinitions((Iterable<? extends AttributeDefinition>)list.attributeDefinitions());
        this.codelistFingerprint = new Fingerprint().addAttributes((Iterable<? extends Attribute>)list.attributes());
    }

    public QName name() {
        return this.name;
    }

    public int size() {
        return this.size;
    }

    public Collection<QName> allNames() {
        HashSet<QName> names = new HashSet<QName>(this.codeFingerprint.attributeNames());
        names.addAll(this.codelistFingerprint.attributeNames());
        return names;
    }

    public Collection<String> codeLanguagesFor(QName name, QName type) {
        return this.codeFingerprint.languagesFor(name, type);
    }

    public Collection<String> codelistLanguagesFor(QName name, QName type) {
        return this.codelistFingerprint.languagesFor(name, type);
    }

    public Collection<QName> codeNames() {
        return this.codeFingerprint.attributeNames();
    }

    public Collection<QName> codelistNames() {
        return this.codelistFingerprint.attributeNames();
    }

    public Collection<QName> codeTypesFor(QName name) {
        return this.codeFingerprint.typesFor(name).keySet();
    }

    public Collection<QName> codelistTypesFor(QName name) {
        return this.codelistFingerprint.typesFor(name).keySet();
    }
}

