/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository;

import java.util.Date;
import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.trait.Named;

public class CodelistCoordinates
implements Named {
    private final String id;
    private final QName name;
    private final String version;
    private final Date creationDate;

    public static CodelistCoordinates coords(String id, QName name, String version, Date creationDate) {
        return new CodelistCoordinates(id, name, version, creationDate);
    }

    public static CodelistCoordinates coordsOf(Codelist.Bean list) {
        return CodelistCoordinates.coordsOf((Codelist)list.entity());
    }

    public static CodelistCoordinates coordsOf(Codelist list) {
        return new CodelistCoordinates(list.id(), list.qname(), list.version(), CommonDefinition.CREATED.dateOf((Described)list));
    }

    public CodelistCoordinates(String id, QName name, String version, Date creationDate) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.creationDate = creationDate;
    }

    public String id() {
        return this.id;
    }

    public Date creationDate() {
        return this.creationDate;
    }

    public QName qname() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public String toString() {
        return "CodelistCoordinates [id=" + this.id + ", name=" + this.name + ", version=" + this.version + ", creationDate=" + this.creationDate + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodelistCoordinates other = (CodelistCoordinates)obj;
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

