/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.cotrix.action.UserAction;
import org.cotrix.common.cdi.Current;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.user.User;
import org.cotrix.repository.UserRepository;
import org.cotrix.security.LoginService;
import org.cotrix.security.SignupService;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LoginTest
extends ApplicationTest {
    @Inject
    @Current
    User currentUser;
    @Inject
    LoginService service;
    @Inject
    UserRepository repository;
    @Inject
    SignupService signupService;
    HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);

    @Test
    public void loginAsGuestIfNoTokenIsAvailable() throws Exception {
        User logged = this.service.login(this.req);
        Assert.assertEquals((Object)Users.guest, (Object)logged);
        Assert.assertEquals((Object)Users.guest.id(), (Object)this.currentUser.id());
    }

    @Test
    public void loginAsCotrix() throws Exception {
        Mockito.when((Object)this.req.getAttribute("name")).thenReturn((Object)Users.cotrix.name());
        Mockito.when((Object)this.req.getAttribute("pwd")).thenReturn((Object)Users.cotrix.name());
        User logged = this.service.login(this.req);
        Assert.assertEquals((Object)logged.name(), (Object)Users.cotrix.name());
    }

    @Test
    public void signUpAndLogin() throws Exception {
        User user = Users.user().name("fifi").email("fifi@me.com").fullName("fifi").build();
        this.signupService.signup(user, "any");
        user = (User)this.repository.lookup(user.id());
        Assert.assertTrue((boolean)user.can(UserAction.EDIT.on(user.id())));
        Assert.assertEquals((Object)user.email(), (Object)"fifi@me.com");
        Mockito.when((Object)this.req.getAttribute("name")).thenReturn((Object)user.name());
        Mockito.when((Object)this.req.getAttribute("pwd")).thenReturn((Object)"any");
        User logged = this.service.login(this.req);
        Assert.assertEquals((Object)logged.name(), (Object)user.name());
    }

    @Test
    public void changePwd() throws Exception {
        User user = Users.user().name("fifi").email("fifi@me.com").fullName("fifi").build();
        this.signupService.signup(user, "old");
        user = (User)this.repository.lookup(user.id());
        this.signupService.changePassword(user, "old", "new");
        Mockito.when((Object)this.req.getAttribute("name")).thenReturn((Object)user.name());
        Mockito.when((Object)this.req.getAttribute("pwd")).thenReturn((Object)"new");
        User logged = this.service.login(this.req);
        Assert.assertEquals((Object)logged.name(), (Object)user.name());
    }

    @Test(expected=IllegalStateException.class)
    public void identitiesAreUnique() throws Exception {
        User user = Users.user().name("fifi").email("fifi@me.com").fullName("fifi").build();
        this.signupService.signup(user, "any");
        User homonymous = Users.user().name("fifi").email("fifi@clone.com").fullName("fi").build();
        this.signupService.signup(homonymous, "any");
    }
}

