/*
 * Decompiled with CFR 0.152.
 */
package org.acme.users;

import java.util.HashSet;
import java.util.Set;
import org.cotrix.action.Action;
import org.cotrix.action.Actions;
import org.cotrix.action.ResourceType;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.UserGrammar;
import org.cotrix.domain.user.FingerPrint;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.junit.Assert;
import org.junit.Test;

public class FingerprintTest {
    Action doit = Actions.action((ResourceType)ResourceType.application, (String)"doit", (String[])new String[0]);
    Action dothat = Actions.action((ResourceType)ResourceType.application, (String)"dothat", (String[])new String[0]);
    Action doitOnCodes = Actions.action((ResourceType)ResourceType.codelists, (String)"doitoncodes", (String[])new String[0]);
    Action doThatOnCodes = Actions.action((ResourceType)ResourceType.codelists, (String)"dothatoncodes", (String[])new String[0]);

    @Test
    public void fingerprintWithApplicationPermissions() {
        User bill = this.bill().can(new Action[]{this.doit, this.dothat}).build();
        FingerPrint fp = bill.fingerprint();
        Assert.assertEquals(this.setOf(ResourceType.application), (Object)fp.types());
        Assert.assertEquals(this.setOf("*"), (Object)fp.resources(ResourceType.application));
        Assert.assertEquals(this.setOf(this.doit, this.dothat), (Object)fp.permissionsOver("*", ResourceType.application));
    }

    @Test
    public void fingerprintWithMixedPermissions() {
        User bill = this.bill().can(new Action[]{this.doit, this.doitOnCodes.on("1"), this.doThatOnCodes}).build();
        FingerPrint fp = bill.fingerprint();
        Assert.assertEquals(this.setOf(ResourceType.application, ResourceType.codelists), (Object)fp.types());
        Assert.assertEquals(this.setOf("*"), (Object)fp.resources(ResourceType.application));
        Assert.assertEquals(this.setOf(this.doit), (Object)fp.permissionsOver("*", ResourceType.application));
        Assert.assertEquals(this.setOf("*", "1"), (Object)fp.resources(ResourceType.codelists));
        Assert.assertEquals(this.setOf(this.doThatOnCodes, this.doitOnCodes.on("1")), (Object)fp.permissionsOver("1", ResourceType.codelists));
        Assert.assertEquals(this.setOf(this.doThatOnCodes), (Object)fp.permissionsOver("*", ResourceType.codelists));
    }

    @Test
    public void fingerprintWithRoles() {
        Role something = this.aUserModel().can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        User bill = this.bill().is(new Role[]{something}).build();
        FingerPrint fp = bill.fingerprint();
        Assert.assertEquals(this.setOf(ResourceType.application), (Object)fp.types());
        Assert.assertEquals(this.setOf(something.name()), (Object)fp.allRolesOver("*", ResourceType.application));
        Assert.assertEquals(this.setOf(something.name()), (Object)fp.specificRolesOver("*", ResourceType.application));
        Assert.assertEquals(this.setOf(this.doit), (Object)fp.permissionsOver("*", ResourceType.application));
    }

    @Test
    public void fingerprintWithRoleTemplates() {
        Role something = this.aUserModel().can(new Action[]{this.doitOnCodes}).buildAsRoleFor(ResourceType.codelists);
        Role somethingElse = this.aUserModel().can(new Action[]{this.doThatOnCodes}).buildAsRoleFor(ResourceType.codelists);
        User bill = this.bill().is(new Role[]{something, somethingElse.on("1")}).build();
        FingerPrint fp = bill.fingerprint();
        Assert.assertEquals(this.setOf(ResourceType.codelists), (Object)fp.types());
        Assert.assertEquals(this.setOf(something.name(), somethingElse.name()), (Object)fp.allRolesOver("1", ResourceType.codelists));
        Assert.assertEquals(this.setOf(somethingElse.name()), (Object)fp.specificRolesOver("1", ResourceType.codelists));
        Assert.assertEquals(this.setOf(something.name()), (Object)fp.allRolesOver("*", ResourceType.codelists));
        Assert.assertEquals(this.setOf(something.name()), (Object)fp.specificRolesOver("*", ResourceType.codelists));
        Assert.assertEquals(this.setOf(this.doitOnCodes), (Object)fp.permissionsOver("*", ResourceType.codelists));
    }

    @Test
    public void fingerprintMixedRoles() {
        Role something = this.aUserModel("something").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        Role somethingElse = this.aUserModel("somethingElse").can(new Action[]{this.doitOnCodes}).buildAsRoleFor(ResourceType.codelists);
        User bill = this.bill().is(new Role[]{something, somethingElse}).build();
        FingerPrint fp = bill.fingerprint();
        Assert.assertEquals(this.setOf(ResourceType.application, ResourceType.codelists), (Object)fp.types());
        Assert.assertEquals(this.setOf(something.name()), (Object)fp.allRolesOver("*", ResourceType.application));
        Assert.assertEquals(this.setOf(this.doit), (Object)fp.permissionsOver("*", ResourceType.application));
        Assert.assertEquals(this.setOf(somethingElse.name()), (Object)fp.allRolesOver("*", ResourceType.codelists));
        Assert.assertEquals(this.setOf(this.doitOnCodes), (Object)fp.permissionsOver("*", ResourceType.codelists));
    }

    @Test
    public void fingerprintWithInstantiatedRoles() {
        Role something = this.aUserModel("something").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        Role somethingElse = this.aUserModel("somethingElse").can(new Action[]{this.doitOnCodes}).buildAsRoleFor(ResourceType.codelists);
        User bill = this.bill().is(new Role[]{something, somethingElse.on("1")}).build();
        FingerPrint fp = bill.fingerprint();
        Assert.assertEquals(this.setOf(ResourceType.application, ResourceType.codelists), (Object)fp.types());
        Assert.assertEquals(this.setOf(something.name()), (Object)fp.allRolesOver("*", ResourceType.application));
        Assert.assertEquals(this.setOf(this.doit), (Object)fp.permissionsOver("*", ResourceType.application));
        Assert.assertEquals(this.setOf(somethingElse.name()), (Object)fp.allRolesOver("1", ResourceType.codelists));
        Assert.assertEquals(this.setOf(this.doitOnCodes.on("1")), (Object)fp.permissionsOver("1", ResourceType.codelists));
    }

    @Test
    public void fingerprintWithRoleHierarchies() {
        Role some = this.aUserModel("some").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        Role more = this.aUserModel("more").is(new Role[]{some}).can(new Action[]{this.dothat}).buildAsRoleFor(ResourceType.application);
        User bill = this.bill().is(new Role[]{more}).build();
        FingerPrint fp = bill.fingerprint();
        Assert.assertEquals(this.setOf(ResourceType.application), (Object)fp.types());
        Assert.assertEquals(this.setOf(some.name(), more.name()), (Object)fp.allRolesOver("*", ResourceType.application));
        Assert.assertEquals(this.setOf(this.doit, this.dothat), (Object)fp.permissionsOver("*", ResourceType.application));
    }

    @Test
    public void fingerprintWithMixedRoleHierarchies() {
        Role some = this.aUserModel("some").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        Role more = this.aUserModel("more").is(new Role[]{some}).can(new Action[]{this.doitOnCodes}).buildAsRoleFor(ResourceType.codelists);
        Role most = this.aUserModel("most").is(new Role[]{more}).can(new Action[]{this.doThatOnCodes}).buildAsRoleFor(ResourceType.codelists);
        User bill = this.bill().is(new Role[]{most.on("1")}).build();
        FingerPrint fp = bill.fingerprint();
        Assert.assertEquals(this.setOf(ResourceType.application, ResourceType.codelists), (Object)fp.types());
        Assert.assertEquals(this.setOf(some.name()), (Object)fp.allRolesOver("*", ResourceType.application));
        Assert.assertEquals(this.setOf(this.doit), (Object)fp.permissionsOver("*", ResourceType.application));
        Assert.assertEquals(this.setOf("1"), (Object)fp.resources(ResourceType.codelists));
        Assert.assertEquals(this.setOf(more.name(), most.name()), (Object)fp.allRolesOver("1", ResourceType.codelists));
        Assert.assertEquals(this.setOf(this.doitOnCodes.on("1"), this.doThatOnCodes.on("1")), (Object)fp.permissionsOver("1", ResourceType.codelists));
    }

    <T> Set<T> setOf(T ... ts) {
        HashSet<T> set = new HashSet<T>();
        for (T t : ts) {
            set.add(t);
        }
        return set;
    }

    private UserGrammar.ThirdClause aUserModel() {
        return this.aUserModel("role");
    }

    private UserGrammar.ThirdClause aUserModel(String name) {
        return Users.user().name(name).noMail().fullName(name);
    }

    private UserGrammar.ThirdClause bill() {
        return Users.user().name("bill").noMail().fullName("bill");
    }
}

