/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import java.util.Arrays;
import javax.xml.namespace.QName;
import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelinkGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.dsl.grammar.CodelistLinkGrammar;
import org.cotrix.domain.dsl.grammar.CommonClauses;
import org.cotrix.domain.memory.CodelinkMS;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.utils.Constants;
import org.cotrix.domain.values.ValueFunctions;
import org.junit.Assert;
import org.junit.Test;

public class CodelinkTest
extends DomainTest {
    @Test
    public void linksCanBeFluentlyConstructed() {
        Code code = this.someTarget();
        CodelistLink listLink = this.someCodelistLink();
        Attribute a = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Codelink link = (Codelink)this.like(((CodelinkGrammar.OptionalClause)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code)).attributes(new Attribute[]{a})).build());
        Assert.assertEquals((Object)listLink, (Object)link.type());
        Assert.assertEquals((Object)link.type().name(), (Object)link.name());
        Assert.assertEquals((Object)a, (Object)link.attributes().lookup(a.name()));
    }

    @Test
    public void changesetCanBeFluentlyConstructed() {
        Codelink link = (Codelink)((CodelinkGrammar.OptionalClause)Codes.modifyLink((String)"1").target((Object)this.someTarget())).build();
        Assert.assertEquals((Object)Status.MODIFIED, (Object)((Codelink.Private)link).status());
    }

    @Test
    public void resolveLinkToNames() {
        Code code = (Code)this.like(((CodeGrammar.OptionalClause)Codes.code().name("a")).build());
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Codes.codelist().name("A")).build());
        CodelistLink listLink = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("link")).target((Object)list)).transformWith(ValueFunctions.lowercase).anchorToName().build());
        Codelink link = (Codelink)this.like(((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code)).build());
        Assert.assertEquals((Object)new QName(code.name().getNamespaceURI(), ValueFunctions.lowercase.apply(code.name().getLocalPart())), link.value().iterator().next());
    }

    @Test
    public void resolveLinkToAttributes() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Constants.defaultType).in(Fixture.language).build());
        Code code = (Code)this.like(((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("b")).attributes(new Attribute[]{a})).build());
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("B")).with((Object[])new Code[]{code})).build());
        Attribute template = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).ofType(Constants.NULL_QNAME).build();
        CodelistLink listLink = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("link")).target((Object)list)).anchorTo(template).transformWith(ValueFunctions.lowercase).build());
        Codelink link = (Codelink)this.like(((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code)).build());
        Assert.assertEquals(Arrays.asList(ValueFunctions.lowercase.apply(a.value())), (Object)link.value());
    }

    @Test
    public void resolveLinkToAttributesWithFunction() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Constants.defaultType).in(Fixture.language).build());
        Code code = (Code)this.like(((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("b")).attributes(new Attribute[]{a})).build());
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("B")).with((Object[])new Code[]{code})).build());
        Attribute template = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).ofType(Constants.NULL_QNAME).build();
        CodelistLink listLink = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("link")).target((Object)list)).anchorTo(template).build());
        Codelink link = (Codelink)this.like(((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code)).build());
        Assert.assertEquals(Arrays.asList(a.value()), (Object)link.value());
    }

    @Test
    public void resolveLinkToLinks() {
        Code code = (Code)this.like(((CodeGrammar.OptionalClause)Codes.code().name("c")).build());
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Codes.codelist().name("C")).build());
        CodelistLink listlink = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("link-to-c")).target((Object)list)).build());
        Codelink link = (Codelink)this.like(((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listlink).target((Object)code)).build());
        code = (Code)this.like(((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("b")).links((Object[])new Codelink[]{link})).build());
        list = (Codelist)this.like(((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("B")).links((Object[])new CodelistLink[]{listlink})).with((Object[])new Code[]{code})).build());
        listlink = (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("link-to-b")).target((Object)list)).anchorTo(listlink).build());
        link = (Codelink)this.like(((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listlink).target((Object)code)).build());
        Assert.assertEquals((Object)Codes.q((String)"c"), link.value().iterator().next());
    }

    @Test
    public void cloned() {
        Attribute a = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Codelink link = (Codelink)((CodelinkGrammar.OptionalClause)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(this.someCodelistLink()).target((Object)this.someTarget())).attributes(new Attribute[]{a})).build();
        Codelink.State state = (Codelink.State)Codes.reveal((Codelink)link).state();
        CodelinkMS clone = new CodelinkMS(state);
        Assert.assertEquals((Object)state.name(), (Object)clone.name());
        for (Attribute.State attr : clone.attributes()) {
            Assert.assertTrue((boolean)clone.attributes().contains(attr.name()));
        }
        Assert.assertFalse((boolean)clone.id().equals(state.id()));
    }

    @Test
    public void changeLinkGroup() {
        Attribute a = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Code code1 = this.someTarget("t1");
        Code code2 = this.someTarget("t2");
        Code code3 = this.someTarget("t3");
        Code code4 = this.someTarget("t4");
        Code code5 = this.someTarget("t5");
        CodelistLink listLink = this.someCodelistLink();
        Codelink link1 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code1)).build();
        Codelink link2 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code1)).build();
        Codelink link3 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code3)).build();
        Codelink link4 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code3)).build();
        Codelink link5 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code5)).build();
        Code code = (Code)this.like(((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("s")).links((Object[])new Codelink[]{link1, link2, link3, link4, link5})).build());
        Codelink delta1 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.modifyLink((String)link1.id()).target((Object)code2)).build();
        Codelink delta4 = (Codelink)((CodelinkGrammar.OptionalClause)((CodelinkGrammar.OptionalClause)Codes.modifyLink((String)link4.id()).target((Object)code4)).attributes(new Attribute[]{a})).build();
        Codelink delta5 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.modifyLink((String)link5.id()).attributes(new Attribute[]{a})).build();
        Code delta = (Code)((CodeGrammar.OptionalClause)Codes.modifyCode((String)code.id()).links((Object[])new Codelink[]{delta1, delta4, delta5})).build();
        Codes.reveal((Code)code).update(Codes.reveal((Code)delta));
        for (Codelink link : code.links()) {
            if (link.id().equals(link1.id())) {
                Assert.assertEquals((Object)code2.id(), (Object)link.target().id());
                continue;
            }
            if (link.id().equals(link2.id())) {
                Assert.assertEquals((Object)code2.id(), (Object)link.target().id());
                continue;
            }
            if (link.id().equals(link4.id())) {
                Assert.assertEquals((Object)code4.id(), (Object)link.target().id());
                Assert.assertTrue((boolean)link.attributes().contains(a.name()));
                continue;
            }
            if (link.id().equals(link3.id())) {
                Assert.assertEquals((Object)code4.name(), (Object)link.target().name());
                Assert.assertFalse((boolean)link.attributes().contains(a.name()));
                continue;
            }
            if (!link.id().equals(link5.id())) continue;
            Assert.assertEquals((Object)code5.id(), (Object)link.target().id());
            Assert.assertTrue((boolean)link.attributes().contains(a.name()));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void linkGroupMustChangeConsistently() {
        Code code1 = this.someTarget("t1");
        Code code2 = this.someTarget("t2");
        Code code3 = this.someTarget("t3");
        CodelistLink listLink = this.someCodelistLink();
        Codelink link1 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code1)).build();
        Codelink link2 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code1)).build();
        Code code = (Code)this.like(((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("s")).links((Object[])new Codelink[]{link1, link2})).build());
        Codelink linkchange1 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.modifyLink((String)link1.id()).target((Object)code2)).build();
        Codelink linkchange3 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.modifyLink((String)link2.id()).target((Object)code3)).build();
        Code codechange = (Code)((CodeGrammar.OptionalClause)Codes.modifyCode((String)code.id()).links((Object[])new Codelink[]{linkchange1, linkchange3})).build();
        try {
            Codes.reveal((Code)code).update(Codes.reveal((Code)codechange));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        linkchange3 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.modifyLink((String)link2.id()).target((Object)code2)).build();
        Codes.reveal((Code)code).update(Codes.reveal((Code)codechange));
    }

    @Test(expected=IllegalStateException.class)
    public void linkCyclesAreDetected() {
        Code code1 = this.someTarget("c1");
        Codelist list1 = (Codelist)this.like(((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("list1")).with((Object[])new Code[]{code1})).build());
        Code code2 = this.someTarget("c2");
        Codelist list2 = (Codelist)this.like(((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("list2")).with((Object[])new Code[]{code2})).build());
        CodelistLink clLink1 = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("1-2")).target((Object)list2)).build();
        Codelist changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list1.id()).links((Object[])new CodelistLink[]{clLink1})).build();
        Codes.reveal((Codelist)list1).update(Codes.reveal((Codelist)changeset));
        CodelistLink clLink2 = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("2-1")).target((Object)list1)).anchorTo(clLink1).build();
        changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list2.id()).links((Object[])new CodelistLink[]{clLink2})).build();
        Codes.reveal((Codelist)list2).update(Codes.reveal((Codelist)changeset));
        changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list1.id()).links((Object[])new CodelistLink[]{(CodelistLink)Codes.modifyListLink((String)clLink1.id()).anchorTo(clLink2).build()})).build();
        Codes.reveal((Codelist)list1).update(Codes.reveal((Codelist)changeset));
        Codelink link1 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(clLink1).target((Object)code2)).build();
        Codelink link2 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(clLink2).target((Object)code1)).build();
        changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list1.id()).with((Object[])new Code[]{(Code)((CodeGrammar.OptionalClause)Codes.modifyCode((String)code1.id()).links((Object[])new Codelink[]{link1})).build()})).build();
        Codes.reveal((Codelist)list1).update(Codes.reveal((Codelist)changeset));
        changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list2.id()).with((Object[])new Code[]{(Code)((CodeGrammar.OptionalClause)Codes.modifyCode((String)code2.id()).links((Object[])new Codelink[]{link2})).build()})).build();
        Codes.reveal((Codelist)list2).update(Codes.reveal((Codelist)changeset));
        ((Codelink)code1.links().lookup(link1.name())).value();
    }

    @Test
    public void changeTarget() {
        Code code = this.someTarget();
        CodelistLink listLink = this.someCodelistLink();
        Codelink link = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code)).build();
        code = this.someTarget("new");
        Codelink changeset = (Codelink)((CodelinkGrammar.OptionalClause)Codes.modifyLink((String)link.id()).target((Object)code)).build();
        Codes.reveal((Codelink)link).update(Codes.reveal((Codelink)changeset));
        Assert.assertEquals((Object)code.name(), link.value().iterator().next());
    }

    @Test
    public void changeAttribute() {
        Code code = this.someTarget();
        CodelistLink listLink = this.someCodelistLink();
        Codelink link = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(listLink).target((Object)code)).build();
        Attribute a = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Codelink changeset = (Codelink)((CodelinkGrammar.OptionalClause)Codes.modifyLink((String)link.id()).attributes(new Attribute[]{a})).build();
        Codes.reveal((Codelink)link).update(Codes.reveal((Codelink)changeset));
        Assert.assertNotNull((Object)link.attributes().lookup(a.name()));
    }

    private CodelistLink someCodelistLink() {
        return (CodelistLink)this.like(((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("link")).target((Object)this.someCodelist())).build());
    }

    private Codelist someCodelist() {
        return (Codelist)this.like(((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build());
    }

    private Code someTarget() {
        return this.someTarget("name");
    }

    private Code someTarget(String name) {
        return (Code)this.like(((CodeGrammar.OptionalClause)Codes.code().name(name)).build());
    }
}

