/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeDefinitionGrammar;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.dsl.grammar.LinkDefinitionGrammar;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.memory.MCodelist;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.DomainUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodelistTest
extends DomainTest {
    Attribute attr = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).build();
    AttributeDefinition def = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name(Fixture.name)).build();
    Attribute shared = (Attribute)Data.attribute().instanceOf(this.def).value(Fixture.value).build();
    Attribute shared2 = (Attribute)Data.attribute().instanceOf(this.def).value(Fixture.value2).build();
    Code tcode1 = (Code)((CodeGrammar.SecondClause)Data.code().name(Fixture.name)).build();
    Code tcode2 = (Code)((CodeGrammar.SecondClause)Data.code().name(Fixture.name2)).build();
    Codelist target = (Codelist)((CodelistGrammar.SecondClause)Data.codelist().name(Fixture.name)).with(new Code[]{this.tcode1, this.tcode2}).build();
    LinkDefinition link = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(this.target).build();
    Link link1 = (Link)Data.link().instanceOf(this.link).target(this.tcode1).build();
    Link link2 = (Link)Data.link().instanceOf(this.link).target(this.tcode2).build();
    Code code = (Code)((CodeGrammar.SecondClause)((CodeGrammar.SecondClause)Data.code().name(Fixture.name)).attributes(new Attribute[]{this.shared, this.shared2})).links(new Link[]{this.link1, this.link2}).build();
    String version = "0.1";
    Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Data.codelist().name(Fixture.name)).definitions(new AttributeDefinition[]{this.def}).attributes(new Attribute[]{this.attr})).with(new Code[]{this.code}).links(new LinkDefinition[]{this.link}).version(this.version).build();

    @Before
    public void stage() {
        this.target = this.like(this.target);
        this.list = this.like(this.list);
    }

    @Test
    public void codelistCanBeFluentlyConstructed() {
        Codelist minimal = (Codelist)((CodelistGrammar.SecondClause)Data.codelist().name(Fixture.name)).build();
        Assert.assertNotNull((Object)minimal.version());
        Assert.assertNotNull((Object)minimal.attributeDefinitions());
        Assert.assertNotNull((Object)minimal.attributes());
        Assert.assertNotNull((Object)minimal.linkDefinitions());
        Assert.assertNotNull((Object)minimal.codes());
        Assert.assertTrue((boolean)this.list.attributes().contains((Named)this.attr));
        Assert.assertTrue((boolean)this.list.codes().contains((Named)this.code));
        Assert.assertTrue((boolean)this.list.linkDefinitions().contains((Named)this.link));
        Assert.assertTrue((boolean)this.list.attributeDefinitions().contains((Named)this.def));
        Assert.assertEquals((Object)this.version, (Object)this.list.version());
    }

    @Test
    public void changesetCanBeFluentlyConstructed() {
        Data.modify((Codelist)this.list).definitions(new AttributeDefinition[]{this.def}).build();
        ((CodelistGrammar.SecondClause)Data.modify((Codelist)this.list).attributes(new Attribute[]{this.attr})).build();
        Data.modify((Codelist)this.list).with(new Code[]{this.code}).build();
        Data.modify((Codelist)this.list).links(new LinkDefinition[]{this.link}).build();
    }

    @Test
    public void canBeCloned() {
        Codelist.Bean state = (Codelist.Bean)Data.reveal((Codelist)this.list).bean();
        MCodelist clone = new MCodelist(state);
        Assert.assertTrue((boolean)clone.attributes().contains(this.attr.qname()));
    }

    @Test
    public void canBeVersioned() {
        Codelist versioned = Data.reveal((Codelist)this.list).bump("2");
        Assert.assertEquals((Object)"2", (Object)versioned.version());
        Assert.assertEquals((Object)this.list.qname(), (Object)CommonDefinition.PREVIOUS_VERSION_NAME.nameOf((Described)versioned));
        Assert.assertEquals((Object)this.list.id(), (Object)CommonDefinition.PREVIOUS_VERSION_ID.of((Described)versioned));
        Assert.assertEquals((Object)this.list.version(), (Object)CommonDefinition.PREVIOUS_VERSION.of((Described)versioned));
        Code vcode = (Code)versioned.codes().getFirst((Named)this.code);
        Assert.assertEquals((Object)this.code.id(), (Object)CommonDefinition.PREVIOUS_VERSION_ID.of((Described)vcode));
        Assert.assertEquals((Object)this.code.qname(), (Object)CommonDefinition.PREVIOUS_VERSION_NAME.nameOf((Described)vcode));
    }

    @Test
    public void versioningPreservesAttributeSharing() {
        Assert.assertSame((Object)DomainUtils.beanOf((AttributeDefinition)((AttributeDefinition)this.shared.definition())), (Object)DomainUtils.beanOf((AttributeDefinition)((AttributeDefinition)this.shared2.definition())));
        Codelist versioned = Data.reveal((Codelist)this.list).bump("2");
        Code vcode = (Code)versioned.codes().getFirst((Named)this.code);
        Attribute vshared = (Attribute)vcode.attributes().lookup(this.shared.id());
        Attribute vshared2 = (Attribute)vcode.attributes().lookup(this.shared2.id());
        Assert.assertEquals((Object)this.shared.definition(), (Object)vshared.definition());
        Assert.assertNotSame((Object)DomainUtils.beanOf((AttributeDefinition)((AttributeDefinition)this.shared.definition())), (Object)DomainUtils.beanOf((AttributeDefinition)((AttributeDefinition)vshared.definition())));
        Assert.assertSame((Object)DomainUtils.beanOf((AttributeDefinition)((AttributeDefinition)vshared.definition())), (Object)DomainUtils.beanOf((AttributeDefinition)((AttributeDefinition)vshared2.definition())));
    }

    @Test
    public void versioningPreservesLinkSharing() {
        Assert.assertSame((Object)DomainUtils.beanOf((LinkDefinition)((LinkDefinition)this.link1.definition())), (Object)DomainUtils.beanOf((LinkDefinition)((LinkDefinition)this.link2.definition())));
        Codelist versioned = Data.reveal((Codelist)this.list).bump("2");
        Code vcode = (Code)versioned.codes().getFirst((Named)this.code);
        Link vlink1 = (Link)vcode.links().lookup(this.link1.id());
        Link vlink2 = (Link)vcode.links().lookup(this.link2.id());
        Assert.assertNotSame((Object)DomainUtils.beanOf((LinkDefinition)((LinkDefinition)this.link1.definition())), (Object)DomainUtils.beanOf((LinkDefinition)((LinkDefinition)vlink1.definition())));
        Assert.assertSame((Object)DomainUtils.beanOf((LinkDefinition)((LinkDefinition)vlink1.definition())), (Object)DomainUtils.beanOf((LinkDefinition)((LinkDefinition)vlink2.definition())));
    }

    @Test(expected=IllegalStateException.class)
    public void versionsMustBeConsistent() {
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Data.codelist().name(Fixture.name)).version("2").build());
        Data.reveal((Codelist)list).bump("1.3");
    }

    @Test
    public void canBeUpdated() {
        AttributeDefinition newdef = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.modify((AttributeDefinition)this.def).name("newname")).build();
        LinkDefinition newlink = (LinkDefinition)((LinkDefinitionGrammar.ThirdClause)Data.modify((LinkDefinition)this.link).name("newname")).build();
        Codelist changeset = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Data.modify((Codelist)this.list).name(Fixture.name2)).definitions(new AttributeDefinition[]{newdef}).attributes(new Attribute[]{Data.delete((Attribute)this.attr)})).with(new Code[]{Data.delete((Code)this.code)}).links(new LinkDefinition[]{newlink}).build();
        Data.reveal((Codelist)this.list).update(Data.reveal((Codelist)changeset));
        Assert.assertEquals((Object)changeset.qname(), (Object)this.list.qname());
        Assert.assertTrue((boolean)this.list.attributeDefinitions().contains((Named)newdef));
        Assert.assertFalse((boolean)this.list.attributes().contains((Named)this.attr));
        Assert.assertTrue((boolean)this.list.linkDefinitions().contains((Named)newlink));
        Assert.assertFalse((boolean)this.list.codes().contains((Named)this.code));
    }
}

