/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.memory.MIdentified;
import org.cotrix.domain.trait.Identified;
import org.junit.Assert;
import org.junit.Test;

public class IdentifiedTest
extends DomainTest {
    @Test
    public void newEntitiesHaveIdentifiers() {
        Identified.Private e = this.like(new MyEntity((Identified.Bean)new MIdentified()));
        Assert.assertNotNull((Object)e.id());
        Assert.assertNull((Object)e.status());
    }

    @Test
    public void identifierAndStatusMustBeValid() {
        try {
            this.like(new MyEntity((Identified.Bean)new MIdentified(null, Status.MODIFIED)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.like(new MyEntity((Identified.Bean)new MIdentified("id", null)));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void changesetsCannotBeNull() {
        MyEntity e = new MyEntity((Identified.Bean)new MIdentified());
        try {
            e.update(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void changesetsCannotBeNew() {
        MyEntity e = new MyEntity((Identified.Bean)new MIdentified());
        MyEntity newEntity = new MyEntity((Identified.Bean)new MIdentified());
        try {
            e.update(newEntity);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void changesetsMustMatchIdentifiers() {
        MyEntity e = new MyEntity((Identified.Bean)new MIdentified());
        try {
            e.update(null);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        MyEntity changeset = new MyEntity((Identified.Bean)new MIdentified("another", Status.MODIFIED));
        try {
            e.update(changeset);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void changesetsCannotBeUpdated() {
        MyEntity changeset = new MyEntity((Identified.Bean)new MIdentified("someid", Status.MODIFIED){});
        try {
            changeset.update(changeset);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void changesetsCannotBeDirectlyDeleted() {
        MyEntity e = new MyEntity((Identified.Bean)new MIdentified());
        MyEntity changeset = new MyEntity((Identified.Bean)new MIdentified("someid", Status.DELETED));
        try {
            e.update(changeset);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class MyEntity
    extends Identified.Private<MyEntity, Identified.Bean> {
        public MyEntity(Identified.Bean state) {
            super(state);
        }
    }
}

