/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import javax.xml.namespace.QName;
import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Ranges;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.dsl.grammar.LinkDefinitionGrammar;
import org.cotrix.domain.links.AttributeLink;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.links.LinkOfLink;
import org.cotrix.domain.links.NameLink;
import org.cotrix.domain.memory.MLinkDef;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.AttributeTemplate;
import org.cotrix.domain.utils.DomainConstants;
import org.cotrix.domain.values.ValueFunction;
import org.cotrix.domain.values.ValueFunctions;
import org.junit.Assert;
import org.junit.Test;

public class LinkDefTest
extends DomainTest {
    @Test
    public void linksCanBeFluentlyConstructed() {
        Codelist target = this.someCodelist(new QName[0]);
        Attribute a = this.someAttribute(new QName[0]);
        LinkDefinition newlink = (LinkDefinition)((LinkDefinitionGrammar.ThirdClause)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(target).attributes(new Attribute[]{a})).build();
        Assert.assertEquals((Object)Fixture.name, (Object)newlink.qname());
        Assert.assertEquals((Object)target, (Object)newlink.target());
        Assert.assertTrue((boolean)newlink.attributes().contains((Named)a));
        Assert.assertEquals((Object)NameLink.INSTANCE, (Object)newlink.valueType());
        Assert.assertEquals((Object)ValueFunctions.identity, (Object)((LinkDefinition.Bean)Data.reveal((LinkDefinition)newlink).bean()).function());
        Assert.assertEquals((Object)DomainConstants.defaultRange, (Object)((LinkDefinition.Bean)Data.reveal((LinkDefinition)newlink).bean()).range());
        newlink = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(target).anchorToName().build();
        Assert.assertEquals((Object)NameLink.INSTANCE, (Object)newlink.valueType());
        Attribute template = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Data.q((String)"this"))).ofType(Data.q((String)"that")).in("this").build();
        newlink = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(target).anchorTo(template).build();
        Assert.assertEquals((Object)new AttributeLink(new AttributeTemplate(template)), (Object)newlink.valueType());
        LinkDefinition linktemplate = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(target).anchorTo(template).build();
        newlink = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(target).anchorTo(linktemplate).build();
        Assert.assertEquals((Object)new LinkOfLink(linktemplate), (Object)newlink.valueType());
        newlink = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(target).transformWith(ValueFunctions.lowercase).build();
        Assert.assertEquals((Object)ValueFunctions.lowercase, (Object)((LinkDefinition.Bean)Data.reveal((LinkDefinition)newlink).bean()).function());
        newlink = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(target).occurs(Ranges.atmost((int)5)).build();
        Assert.assertEquals((Object)Ranges.atmost((int)5), (Object)((LinkDefinition.Bean)Data.reveal((LinkDefinition)newlink).bean()).range());
    }

    @Test
    public void changesetCanBeFluentlyConstructed() {
        LinkDefinition link = (LinkDefinition)((LinkDefinitionGrammar.ThirdClause)Data.modifyLinkDef((String)"1").name(Fixture.name)).build();
        link = (LinkDefinition)((LinkDefinitionGrammar.ThirdClause)Data.modifyLinkDef((String)"1").attributes(new Attribute[]{this.someAttribute(new QName[0])})).build();
        link = (LinkDefinition)Data.modifyLinkDef((String)"1").anchorTo(this.someTemplate(new QName[0])).build();
        link = (LinkDefinition)Data.modifyLinkDef((String)"1").anchorToName().build();
        LinkDefinition linktemplate = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(this.someCodelist(new QName[0])).build();
        link = (LinkDefinition)Data.modifyLinkDef((String)"1").anchorTo(linktemplate).build();
        link = (LinkDefinition)Data.modifyLinkDef((String)"1").transformWith(ValueFunctions.uppercase).build();
        link = (LinkDefinition)Data.modifyLinkDef((String)"1").occurs(Ranges.atmostonce).build();
        link = (LinkDefinition)((LinkDefinitionGrammar.ThirdClause)((LinkDefinitionGrammar.ThirdClause)Data.modifyLinkDef((String)"1").name(Fixture.name)).attributes(new Attribute[]{this.someAttribute(new QName[0])})).anchorTo(this.someTemplate(new QName[0])).transformWith(ValueFunctions.lowercase).occurs(Ranges.atmostonce).build();
        Assert.assertEquals((Object)Status.MODIFIED, (Object)((LinkDefinition.Private)link).status());
    }

    @Test
    public void linksCanBeCloned() {
        LinkDefinition fullLinkWithoutDefaults = (LinkDefinition)this.like(((LinkDefinitionGrammar.ThirdClause)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(this.someCodelist(new QName[0])).anchorTo(this.someTemplate(new QName[0])).transformWith(ValueFunctions.lowercase).occurs(Ranges.once).attributes(new Attribute[]{this.someAttribute(new QName[0])})).build());
        LinkDefinition.Bean state = (LinkDefinition.Bean)Data.reveal((LinkDefinition)fullLinkWithoutDefaults).bean();
        MLinkDef clone = new MLinkDef(state);
        Assert.assertEquals((Object)state.qname(), (Object)clone.qname());
        Assert.assertEquals((Object)state.target().id(), (Object)clone.target().id());
        Assert.assertEquals((Object)state.valueType(), (Object)clone.valueType());
        Assert.assertEquals((Object)state.function(), (Object)clone.function());
        Assert.assertEquals((Object)state.range(), (Object)clone.range());
        for (Attribute.Bean attr : clone.attributes()) {
            Assert.assertTrue((boolean)clone.attributes().contains(attr.qname()));
        }
        Assert.assertFalse((boolean)clone.id().equals(state.id()));
        this.like(new LinkDefinition.Private((LinkDefinition.Bean)clone));
    }

    @Test
    public void linksCanChangeName() {
        LinkDefinition link = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(this.someCodelist(new QName[0])).build());
        LinkDefinition changeset = (LinkDefinition)((LinkDefinitionGrammar.ThirdClause)Data.modifyLinkDef((String)link.id()).name(Fixture.name2)).build();
        Data.reveal((LinkDefinition)link).update(Data.reveal((LinkDefinition)changeset));
        Assert.assertEquals((Object)Fixture.name2, (Object)link.qname());
    }

    @Test
    public void linksCanChangeValueType() {
        LinkDefinition link = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(this.someCodelist(new QName[0])).build());
        Attribute template = this.someTemplate(new QName[0]);
        LinkDefinition changeset = (LinkDefinition)Data.modifyLinkDef((String)link.id()).anchorTo(template).build();
        Data.reveal((LinkDefinition)link).update(Data.reveal((LinkDefinition)changeset));
        Assert.assertEquals((Object)new AttributeLink(new AttributeTemplate(template)), (Object)link.valueType());
    }

    @Test
    public void linksCanChangeValueTypeBackToDefault() {
        LinkDefinition linktemplate = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(this.someCodelist(new QName[0])).build());
        LinkDefinition link = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(this.someCodelist(new QName[0])).anchorTo(linktemplate).build());
        LinkDefinition changeset = (LinkDefinition)Data.modifyLinkDef((String)link.id()).anchorToName().build();
        Data.reveal((LinkDefinition)link).update(Data.reveal((LinkDefinition)changeset));
        Assert.assertEquals((Object)NameLink.INSTANCE, (Object)link.valueType());
    }

    @Test
    public void linksCanChangeRange() {
        LinkDefinition link = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(this.someCodelist(new QName[0])).build());
        LinkDefinition changeset = (LinkDefinition)Data.modifyLinkDef((String)link.id()).occurs(Ranges.once).build();
        Data.reveal((LinkDefinition)link).update(Data.reveal((LinkDefinition)changeset));
        Assert.assertEquals((Object)Ranges.once, (Object)link.range());
    }

    @Test
    public void linksCanChangeFunction() {
        LinkDefinition link = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name(Fixture.name)).target(this.someCodelist(new QName[0])).build());
        LinkDefinition changeset = (LinkDefinition)Data.modifyLinkDef((String)link.id()).transformWith((ValueFunction)ValueFunctions.custom((String)"'Hello $value'")).build();
        Data.reveal((LinkDefinition)link).update(Data.reveal((LinkDefinition)changeset));
        Assert.assertEquals((Object)ValueFunctions.custom((String)"'Hello $value'"), (Object)link.function());
    }

    private Codelist someCodelist(QName ... n) {
        return (Codelist)this.like(((CodelistGrammar.SecondClause)Data.codelist().name(n.length > 0 ? n[0] : Fixture.name)).build());
    }

    private Attribute someAttribute(QName ... n) {
        return (Attribute)this.like(((AttributeGrammar.FourthClause)Data.attribute().name(n.length > 0 ? n[0] : Fixture.name)).ofType(Data.q((String)"that")).in("this").build());
    }

    private Attribute someTemplate(QName ... n) {
        return (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(n.length > 0 ? n[0] : Fixture.name)).ofType(Data.q((String)"that")).in("this").build();
    }
}

