/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import java.util.Arrays;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.dsl.grammar.LinkDefinitionGrammar;
import org.cotrix.domain.dsl.grammar.LinkGrammar;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.memory.MLink;
import org.cotrix.domain.memory.MLinkDef;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.DomainConstants;
import org.cotrix.domain.utils.DomainUtils;
import org.cotrix.domain.values.ValueFunctions;
import org.junit.Assert;
import org.junit.Test;

public class LinkTest
extends DomainTest {
    @Test
    public void linksCanBeFluentlyConstructed() {
        Code code = this.someTarget();
        LinkDefinition listLink = this.someLinkDef();
        Attribute a = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Link link = (Link)this.like(((LinkGrammar.ThirdClause)Data.link().instanceOf(listLink).target(code).attributes(new Attribute[]{a})).build());
        Assert.assertEquals((Object)listLink, (Object)link.definition());
        Assert.assertEquals((Object)((LinkDefinition)link.definition()).qname(), (Object)link.qname());
        Assert.assertEquals((Object)a, (Object)link.attributes().getFirst((Named)a));
    }

    @Test
    public void changesetCanBeFluentlyConstructed() {
        Link link = (Link)Data.modifyLink((String)"1").target(this.someTarget()).build();
        Assert.assertEquals((Object)Status.MODIFIED, (Object)((Link.Private)link).status());
    }

    @Test
    public void resolveLinkToNames() {
        Code code = (Code)this.like(((CodeGrammar.SecondClause)Data.code().name("a")).build());
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Data.codelist().name("A")).build());
        LinkDefinition listLink = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name("link")).target(list).transformWith(ValueFunctions.lowercase).anchorToName().build());
        Link link = (Link)this.like(Data.link().instanceOf(listLink).target(code).build());
        Assert.assertEquals((Object)new QName(code.qname().getNamespaceURI(), ValueFunctions.lowercase.apply(code.qname().getLocalPart())), link.value().iterator().next());
    }

    @Test
    public void resolveLinkToAttributes() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).value(Fixture.value).ofType(DomainConstants.defaultType).in(Fixture.language).build());
        Code code = (Code)this.like(((CodeGrammar.SecondClause)((CodeGrammar.SecondClause)Data.code().name("b")).attributes(new Attribute[]{a})).build());
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Data.codelist().name("B")).with(new Code[]{code}).build());
        Attribute template = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).ofType(DomainConstants.NULL_QNAME).build();
        LinkDefinition listLink = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name("link")).target(list).anchorTo(template).transformWith(ValueFunctions.lowercase).build());
        Link link = (Link)this.like(Data.link().instanceOf(listLink).target(code).build());
        Assert.assertEquals(Arrays.asList(ValueFunctions.lowercase.apply(a.value())), (Object)link.value());
    }

    @Test
    public void resolveLinkToAttributesWithFunction() {
        Attribute a = (Attribute)this.like(((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).value(Fixture.value).ofType(DomainConstants.defaultType).in(Fixture.language).build());
        Code code = (Code)this.like(((CodeGrammar.SecondClause)((CodeGrammar.SecondClause)Data.code().name("b")).attributes(new Attribute[]{a})).build());
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Data.codelist().name("B")).with(new Code[]{code}).build());
        Attribute template = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).ofType(DomainConstants.NULL_QNAME).build();
        LinkDefinition listLink = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name("link")).target(list).anchorTo(template).build());
        Link link = (Link)this.like(Data.link().instanceOf(listLink).target(code).build());
        Assert.assertEquals(Arrays.asList(a.value()), (Object)link.value());
    }

    @Test
    public void resolveLinkToLinks() {
        Code code = (Code)this.like(((CodeGrammar.SecondClause)Data.code().name("c")).build());
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Data.codelist().name("C")).build());
        LinkDefinition listlink = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name("link-to-c")).target(list).build());
        Link link = (Link)this.like(Data.link().instanceOf(listlink).target(code).build());
        code = (Code)this.like(((CodeGrammar.SecondClause)Data.code().name("b")).links(new Link[]{link}).build());
        list = (Codelist)this.like(((CodelistGrammar.SecondClause)Data.codelist().name("B")).links(new LinkDefinition[]{listlink}).with(new Code[]{code}).build());
        listlink = (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name("link-to-b")).target(list).anchorTo(listlink).build());
        link = (Link)this.like(Data.link().instanceOf(listlink).target(code).build());
        Assert.assertEquals((Object)Data.q((String)"c"), link.value().iterator().next());
    }

    @Test
    public void cloned() {
        Attribute a = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Link link = (Link)((LinkGrammar.ThirdClause)Data.link().instanceOf(this.someLinkDef()).target(this.someTarget()).attributes(new Attribute[]{a})).build();
        Link.Bean state = (Link.Bean)Data.reveal((Link)link).bean();
        HashMap<String, MLinkDef> context = new HashMap<String, MLinkDef>();
        context.put(((LinkDefinition)link.definition()).id(), new MLinkDef(DomainUtils.beanOf((LinkDefinition)((LinkDefinition)link.definition()))));
        MLink clone = new MLink(state, context);
        Assert.assertEquals((Object)state.qname(), (Object)clone.qname());
        for (Attribute.Bean attr : clone.attributes()) {
            Assert.assertTrue((boolean)clone.attributes().contains(attr.qname()));
        }
        Assert.assertEquals((Object)clone.id(), (Object)state.id());
    }

    @Test
    public void changeLinkGroup() {
        Attribute a = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Code code1 = this.someTarget("t1");
        Code code2 = this.someTarget("t2");
        Code code3 = this.someTarget("t3");
        Code code4 = this.someTarget("t4");
        Code code5 = this.someTarget("t5");
        LinkDefinition listLink = this.someLinkDef();
        Link link1 = (Link)Data.link().instanceOf(listLink).target(code1).build();
        Link link2 = (Link)Data.link().instanceOf(listLink).target(code1).build();
        Link link3 = (Link)Data.link().instanceOf(listLink).target(code3).build();
        Link link4 = (Link)Data.link().instanceOf(listLink).target(code3).build();
        Link link5 = (Link)Data.link().instanceOf(listLink).target(code5).build();
        Code code = (Code)this.like(((CodeGrammar.SecondClause)Data.code().name("s")).links(new Link[]{link1, link2, link3, link4, link5}).build());
        Link delta1 = (Link)Data.modifyLink((String)link1.id()).target(code2).build();
        Link delta4 = (Link)((LinkGrammar.ThirdClause)Data.modifyLink((String)link4.id()).target(code4).attributes(new Attribute[]{a})).build();
        Link delta5 = (Link)((LinkGrammar.ThirdClause)Data.modifyLink((String)link5.id()).attributes(new Attribute[]{a})).build();
        Code delta = (Code)Data.modifyCode((String)code.id()).links(new Link[]{delta1, delta4, delta5}).build();
        Data.reveal((Code)code).update(Data.reveal((Code)delta));
        for (Link link : code.links()) {
            if (link.id().equals(link1.id())) {
                Assert.assertEquals((Object)code2.id(), (Object)link.target().id());
                continue;
            }
            if (link.id().equals(link2.id())) {
                Assert.assertEquals((Object)code2.id(), (Object)link.target().id());
                continue;
            }
            if (link.id().equals(link4.id())) {
                Assert.assertEquals((Object)code4.id(), (Object)link.target().id());
                Assert.assertTrue((boolean)link.attributes().contains((Named)a));
                continue;
            }
            if (link.id().equals(link3.id())) {
                Assert.assertEquals((Object)code4.qname(), (Object)link.target().qname());
                Assert.assertFalse((boolean)link.attributes().contains((Named)a));
                continue;
            }
            if (!link.id().equals(link5.id())) continue;
            Assert.assertEquals((Object)code5.id(), (Object)link.target().id());
            Assert.assertTrue((boolean)link.attributes().contains((Named)a));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void linkGroupMustChangeConsistently() {
        Code code1 = this.someTarget("t1");
        Code code2 = this.someTarget("t2");
        Code code3 = this.someTarget("t3");
        LinkDefinition listLink = this.someLinkDef();
        Link link1 = (Link)Data.link().instanceOf(listLink).target(code1).build();
        Link link2 = (Link)Data.link().instanceOf(listLink).target(code1).build();
        Code code = (Code)this.like(((CodeGrammar.SecondClause)Data.code().name("s")).links(new Link[]{link1, link2}).build());
        Link linkchange1 = (Link)Data.modifyLink((String)link1.id()).target(code2).build();
        Link linkchange3 = (Link)Data.modifyLink((String)link2.id()).target(code3).build();
        Code codechange = (Code)Data.modifyCode((String)code.id()).links(new Link[]{linkchange1, linkchange3}).build();
        try {
            Data.reveal((Code)code).update(Data.reveal((Code)codechange));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        linkchange3 = (Link)Data.modifyLink((String)link2.id()).target(code2).build();
        Data.reveal((Code)code).update(Data.reveal((Code)codechange));
    }

    @Test(expected=IllegalStateException.class)
    public void linkCyclesAreDetected() {
        Code code1 = this.someTarget("c1");
        Codelist list1 = (Codelist)this.like(((CodelistGrammar.SecondClause)Data.codelist().name("list1")).with(new Code[]{code1}).build());
        Code code2 = this.someTarget("c2");
        Codelist list2 = (Codelist)this.like(((CodelistGrammar.SecondClause)Data.codelist().name("list2")).with(new Code[]{code2}).build());
        LinkDefinition clLink1 = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name("1-2")).target(list2).build();
        Codelist changeset = (Codelist)Data.modifyCodelist((String)list1.id()).links(new LinkDefinition[]{clLink1}).build();
        Data.reveal((Codelist)list1).update(Data.reveal((Codelist)changeset));
        LinkDefinition clLink2 = (LinkDefinition)((LinkDefinitionGrammar.SecondClause)Data.linkdef().name("2-1")).target(list1).anchorTo(clLink1).build();
        changeset = (Codelist)Data.modifyCodelist((String)list2.id()).links(new LinkDefinition[]{clLink2}).build();
        Data.reveal((Codelist)list2).update(Data.reveal((Codelist)changeset));
        changeset = (Codelist)Data.modifyCodelist((String)list1.id()).links(new LinkDefinition[]{(LinkDefinition)Data.modifyLinkDef((String)clLink1.id()).anchorTo(clLink2).build()}).build();
        Data.reveal((Codelist)list1).update(Data.reveal((Codelist)changeset));
        Link link1 = (Link)Data.link().instanceOf(clLink1).target(code2).build();
        Link link2 = (Link)Data.link().instanceOf(clLink2).target(code1).build();
        changeset = (Codelist)Data.modifyCodelist((String)list1.id()).with(new Code[]{(Code)Data.modifyCode((String)code1.id()).links(new Link[]{link1}).build()}).build();
        Data.reveal((Codelist)list1).update(Data.reveal((Codelist)changeset));
        changeset = (Codelist)Data.modifyCodelist((String)list2.id()).with(new Code[]{(Code)Data.modifyCode((String)code2.id()).links(new Link[]{link2}).build()}).build();
        Data.reveal((Codelist)list2).update(Data.reveal((Codelist)changeset));
        ((Link.Private)code1.links().getFirst((Named)link1)).value();
    }

    @Test
    public void changeTarget() {
        Code code = this.someTarget();
        LinkDefinition listLink = this.someLinkDef();
        Link link = (Link)Data.link().instanceOf(listLink).target(code).build();
        code = this.someTarget("new");
        Link changeset = (Link)Data.modifyLink((String)link.id()).target(code).build();
        Data.reveal((Link)link).update(Data.reveal((Link)changeset));
        Assert.assertEquals((Object)code.qname(), link.value().iterator().next());
    }

    @Test
    public void changeAttribute() {
        Code code = this.someTarget();
        LinkDefinition linkdef = this.someLinkDef();
        Link link = (Link)Data.link().instanceOf(linkdef).target(code).build();
        Attribute a = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Link changeset = (Link)((LinkGrammar.ThirdClause)Data.modifyLink((String)link.id()).attributes(new Attribute[]{a})).build();
        Data.reveal((Link)link).update(Data.reveal((Link)changeset));
        Assert.assertNotNull((Object)link.attributes().getFirst((Named)a));
    }

    private LinkDefinition someLinkDef() {
        return (LinkDefinition)this.like(((LinkDefinitionGrammar.SecondClause)Data.linkdef().name("link")).target(this.someCodelist()).build());
    }

    private Codelist someCodelist() {
        return (Codelist)this.like(((CodelistGrammar.SecondClause)Data.codelist().name("name")).build());
    }

    private Code someTarget() {
        return this.someTarget("name");
    }

    private Code someTarget(String name) {
        return (Code)this.like(((CodeGrammar.SecondClause)Data.code().name(name)).build());
    }
}

