package org.cotrix.web.users.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;

public interface UsersServiceAsync
{

    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void getRoles( org.cotrix.web.users.shared.RolesType type, AsyncCallback<java.util.List<java.lang.String>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void getApplicationRolesRows( com.google.gwt.view.client.Range range, org.cotrix.web.common.shared.ColumnSortInfo sortInfo, AsyncCallback<org.cotrix.web.common.shared.DataWindow<org.cotrix.web.users.shared.RolesRow>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void getUserApplicationRoles( AsyncCallback<java.util.Map<java.lang.String,org.cotrix.web.users.shared.RoleState>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void getCodelistRolesRows( java.lang.String codelistId, com.google.gwt.view.client.Range range, org.cotrix.web.common.shared.ColumnSortInfo sortInfo, AsyncCallback<org.cotrix.web.common.shared.DataWindow<org.cotrix.web.users.shared.RolesRow>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void codelistRoleUpdated( java.lang.String userId, java.lang.String codelistId, java.lang.String role, org.cotrix.web.users.shared.RoleAction action, AsyncCallback<org.cotrix.web.users.shared.RolesRow> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void codelistRolesRowRemoved( java.lang.String codelistId, org.cotrix.web.users.shared.RolesRow row, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void applicationRoleUpdated( java.lang.String userId, java.lang.String role, org.cotrix.web.users.shared.RoleAction action, AsyncCallback<org.cotrix.web.users.shared.RolesRow> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void getCodelistGroups( AsyncCallback<org.cotrix.web.common.shared.DataWindow<org.cotrix.web.users.shared.CodelistGroup>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void getUsersDetails( AsyncCallback<org.cotrix.web.common.shared.DataWindow<org.cotrix.web.users.shared.UIUserDetails>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void getUserDetails( java.lang.String userId, AsyncCallback<org.cotrix.web.users.shared.UIUserDetails> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void saveUserDetails( org.cotrix.web.users.shared.UIUserDetails userDetails, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void updateUserPassword( java.lang.String userId, java.lang.String oldPassword, java.lang.String newPassword, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.cotrix.web.users.client.UsersService
     */
    void removeUser( java.lang.String userId, AsyncCallback<Void> callback );


    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static UsersServiceAsync instance;

        public static final UsersServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (UsersServiceAsync) GWT.create( UsersService.class );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instanciated
        }
    }
}
