/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.client.providers.token.impl;

import java.net.URL;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.fao.fi.security.client.providers.token.spi.TokenProducerServiceClient;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.support.token.spi.TokenProcessor;
import org.glassfish.jersey.client.ClientConfig;

public abstract class AbstractTokenProviderServiceClient
implements TokenProducerServiceClient {
    private Client _client = null;
    private ClientConfig _config = new ClientConfig();
    private URL _endpoint;
    private TokenProcessor _tokenProcessor;

    public AbstractTokenProviderServiceClient(URL endpoint, TokenProcessor tokenProcessor) {
        this._endpoint = endpoint;
        this._tokenProcessor = tokenProcessor;
        this._client = ClientBuilder.newClient((Configuration)this._config);
    }

    protected final Invocation.Builder buildRequest() {
        return this._client.target(this._endpoint.toString()).request().accept(new String[]{"text/plain"});
    }

    @Override
    public final String requestToken() throws TokenProcessingException {
        return this.extractToken(this.request());
    }

    @Override
    public final Response request() {
        return this.buildRequest().get();
    }

    @Override
    public String extractToken(Response response) throws TokenProcessingException {
        if (response.getStatus() == 200) {
            return this._tokenProcessor.processBeforeConsumption((String)response.readEntity(String.class));
        }
        if (response.getStatus() == 404) {
            throw new NotFoundException(response);
        }
        throw new ClientErrorException(response.getStatus());
    }

    public final void registerFilter(ClientRequestFilter toRegister) {
        this._client.register((Object)toRegister);
    }
}

