/**
 * (c) 2014 FAO / UN (project: fi-security-client)
 */
package org.fao.fi.security.client.javax.filters;

import java.io.IOException;
import java.security.GeneralSecurityException;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;

import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.decryption.DecryptionService;
import org.fao.fi.security.common.support.decryption.EncryptedInputStreamWrapper;
import org.fao.fi.security.common.utilities.LoggingClient;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 2 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 2 May 2014
 */
public class EncryptedResponseDecorator extends LoggingClient implements ClientResponseFilter {
	@Inject private @Singleton DecryptionService _decryptor;
	
	/**
	 * Class constructor
	 *
	 * @param decryptor
	 */
	public EncryptedResponseDecorator(DecryptionService decryptor) {
		super();
		
		this._decryptor = decryptor;
	}

	/* (non-Javadoc)
	 * @see javax.ws.rs.client.ClientResponseFilter#filter(javax.ws.rs.client.ClientRequestContext, javax.ws.rs.client.ClientResponseContext)
	 */
	@Override
	public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
		try {
			responseContext.setEntityStream(new EncryptedInputStreamWrapper(responseContext.getEntityStream(), this._decryptor));
		} catch(GeneralSecurityException se) {
			this._log.error(se.getMessage(), se);

			throw new javax.ws.rs.BadRequestException("You are not authorized to access this resource", Response.status(Response.Status.BAD_REQUEST).build());
		} catch(KeyringException kre) {
			this._log.error(kre.getMessage(), kre);

			throw new javax.ws.rs.BadRequestException("You are not authorized to access this resource", Response.status(Response.Status.BAD_REQUEST).build());
		} catch(Throwable t) {
			throw new javax.ws.rs.ServerErrorException("An unexpected server-side error occurred while attempting to access this resource", Response.status(Response.Status.BAD_REQUEST).build());
		}
	}
}
