/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.common.support.decryption.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;

import javax.inject.Inject;

import org.bouncycastle.openpgp.PGPException;
import org.fao.fi.security.common.encryption.pgp.PGPDecryptorBean;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.decryption.DecryptionService;
import org.fao.fi.security.common.utilities.LoggingClient;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 2 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 2 May 2014
 */
public class PGPRequestDecryptionServiceProvider extends LoggingClient implements DecryptionService {
	private PGPDecryptorBean _decryptor;
	
	/**
	 * Class constructor
	 *
	 * @param decryptor
	 */
	@Inject public PGPRequestDecryptionServiceProvider(PGPDecryptorBean decryptor) {
		super();
		this._decryptor = decryptor;
	}

	@Override
	public void decrypt(InputStream incoming, OutputStream outgoing) throws IOException, KeyringException, GeneralSecurityException {
		try {
			this._decryptor.decryptStream(incoming, outgoing);
		} catch(PGPException Pe) {
			throw new GeneralSecurityException(Pe);
		}
	}
}
