/**
 * (c) 2014 FAO / UN (project: fi-security-common)
 */
package org.fao.fi.security.common.utilities.pgp.configuration.impl.jndi;

import javax.naming.NamingException;

import org.fao.fi.security.common.utilities.pgp.configuration.SecretKeyringConfiguration;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 1 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 1 May 2014
 */
public class SecretKeyringJNDIConfiguration extends KeyringJNDIConfiguration implements SecretKeyringConfiguration {
	protected String _keyringPassphraseJNDIName;

	
	/**
	 * Class constructor
	 *
	 * @param keyringResourceJNDIName
	 * @throws NamingException
	 */
	public SecretKeyringJNDIConfiguration(String keyringResourceJNDIName, String keyringPassphraseJNDIName) throws NamingException {
		super(keyringResourceJNDIName);
		
		this._keyringPassphraseJNDIName = keyringPassphraseJNDIName;
	}

	/**
	 * @return the 'keyringPassphraseJNDIName' value
	 */
	public String getKeyringPassphraseJNDIName() {
		return this._keyringPassphraseJNDIName;
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.common.pgp.configuration.PrivateKeyringConfigurator#getKeyringPassphrase()
	 */
	@Override
	public String getKeyringPassphrase() {
		return this.getEnvResource(this._keyringPassphraseJNDIName);
	}
}