/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.support.decryption.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import org.bouncycastle.openpgp.PGPException;
import org.fao.fi.security.common.encryption.pgp.PGPDecryptorBean;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.decryption.DecryptionService;
import org.fao.fi.security.common.utilities.LoggingClient;

public class PGPRequestDecryptionServiceProvider
extends LoggingClient
implements DecryptionService {
    private PGPDecryptorBean _decryptor;

    @Inject
    public PGPRequestDecryptionServiceProvider(PGPDecryptorBean decryptor) {
        this._decryptor = decryptor;
    }

    @Override
    public void decrypt(InputStream incoming, OutputStream outgoing) throws IOException, KeyringException, GeneralSecurityException {
        try {
            this._decryptor.decryptStream(incoming, outgoing);
        }
        catch (PGPException Pe) {
            throw new GeneralSecurityException(Pe);
        }
    }
}

