/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.support.configuration;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.fao.fi.security.common.support.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJNDIConfiguration
implements Configuration {
    protected Logger _log = LoggerFactory.getLogger(this.getClass());
    protected Context _initialContext = new InitialContext();
    protected Context _envContext = (Context)this._initialContext.lookup("java:comp/env/");

    protected <R> R getEnvResource(String resourceName) {
        try {
            return (R)this._envContext.lookup(resourceName);
        }
        catch (NamingException Ne) {
            this._log.warn("Unable to access JNDI resource at {}: {} [ {} ]", new Object[]{resourceName, Ne.getClass().getName(), Ne.getMessage(), Ne});
            throw new IllegalArgumentException("Unable to access JNDI resource at " + resourceName, Ne);
        }
        catch (Exception e) {
            this._log.warn("Unexpected error while attempting to access JNDI resource at {}: {} [ {} ]", new Object[]{resourceName, e.getClass().getName(), e.getMessage(), e});
            throw new IllegalArgumentException("Unexpected error while attempting to access JNDI resource at " + resourceName, e);
        }
    }
}

