/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.support.encryption.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import javax.inject.Inject;
import org.bouncycastle.openpgp.PGPException;
import org.fao.fi.security.common.encryption.pgp.PGPEncryptorBean;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.encryption.EncryptionService;
import org.fao.fi.security.common.utilities.LoggingClient;

public class PGPResponseEncryptionServiceProvider
extends LoggingClient
implements EncryptionService {
    private PGPEncryptorBean _encryptor;

    @Inject
    public PGPResponseEncryptionServiceProvider(PGPEncryptorBean encryptor) {
        this._encryptor = encryptor;
    }

    @Override
    public void encrypt(InputStream incoming, OutputStream outgoing) throws IOException, KeyringException, NoSuchProviderException, GeneralSecurityException {
        try {
            this._encryptor.encryptStream(incoming, outgoing);
        }
        catch (PGPException Pe) {
            throw new GeneralSecurityException(Pe);
        }
    }
}

