/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.javax.filters.origin.configuration;

import java.util.regex.Pattern;

import javax.naming.NamingException;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 8 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 8 May 2014
 */
public class RestrictedIPsSimpleConfiguration implements RestrictedIPsConfiguration {
	private String _restrictedIPsValidationRegexp;

	/**
	 * Class constructor
	 *
	 * @param restrictedIPsValidationRegexp
	 * @throws NamingException
	 */
	public RestrictedIPsSimpleConfiguration(String restrictedIPsValidationRegexp) {
		super();
		
		this._restrictedIPsValidationRegexp = restrictedIPsValidationRegexp;
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.javax.filters.origin.config.RestrictedIPsConfiguration#getValidationRegexp()
	 */
	@Override
	public String getValidationRegexp() {
		return this._restrictedIPsValidationRegexp;
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.javax.filters.origin.config.RestrictedIPsConfiguration#getValidationMatcher()
	 */
	@Override
	public Pattern getValidationPattern() {
		return Pattern.compile(this._restrictedIPsValidationRegexp);
	}
	
	public String toString() {
		return this.getClass().getSimpleName() + " [ Validation REGEXP: " + this._restrictedIPsValidationRegexp + " ]";
	}	
}