/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.javax.filters.origin.support;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import org.fao.fi.security.server.javax.filters.origin.IPIdentifier;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 15 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 15 May 2014
 */
abstract public class AbstractIPIdentifier implements IPIdentifier {
	/**
	 * Class constructor
	 *
	 */
	public AbstractIPIdentifier() {
	}
		
	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.javax.filters.origin.IPIdentifier#identify(javax.servlet.http.HttpServletRequest)
	 */
	@Override
	final public String[] identify(HttpServletRequest request) {
		String host = request.getRemoteHost();
		String xff = request.getHeader("X-FORWARDED-FOR");
		
		Collection<String> IPs = new ArrayList<String>();
		
		host = host == null ? null : host.trim();
		xff = xff == null ? null : xff.trim();
		
		if(host != null && !this.excludeRemoteHost(host)) IPs.add(host);
		
		if(xff != null && this.includeXFF(xff)) {
			for(String in : xff.split("\\,")) {
				if(in != null) {
					in = in.trim();
					
					if(!"".equals(in))
						IPs.add(in);
				}
			}
		}
		
		return this.filter(IPs.toArray(new String[IPs.size()]));
	}
	
	abstract protected String[] filter(String[] IPs);
}